/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utils;

import eu.dnetlib.data.mdstore.plugins.GenericDoiMdstorePlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class HttpFetcher {
    private static final Log log = LogFactory.getLog(GenericDoiMdstorePlugin.class);
    public static final int MAX_NUMBER_OF_ATTEMPTS = 3;
    private static final int INTERVAL_MILLIS = 20000;
    private static final SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
    private static SSLConnectionSocketFactory sslSocketFactory;
    private static final HttpComponentsClientHttpRequestFactory httpRequestFactory;

    public static String fetch(String url) throws URISyntaxException {
        return HttpFetcher.fetch(new URI(url), 1);
    }

    public static String fetch(URI url) {
        return HttpFetcher.fetch(url, 1);
    }

    public static String fetch(URI url, int attempts) {
        if (attempts > 3) {
            log.error((Object)("Max number of attempts reached, downloading url: " + url));
            return "";
        }
        try {
            log.debug((Object)("Downloading URL: " + url + " - try: " + attempts));
            return (String)new RestTemplate((ClientHttpRequestFactory)httpRequestFactory).getForObject(url, String.class);
        }
        catch (Throwable e) {
            try {
                log.error((Object)("Error downloading url: " + url + " - try: " + attempts + " - " + e.getMessage()));
                Thread.sleep(20000L);
                return HttpFetcher.fetch(url, attempts + 1);
            }
            catch (InterruptedException e1) {
                log.error((Object)e);
                return "";
            }
        }
    }

    static {
        try {
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
            sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error((Object)e);
        }
        httpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)HttpClientBuilder.create().setConnectionTimeToLive(0L, TimeUnit.MILLISECONDS).setMaxConnPerRoute(1).setMaxConnTotal(1).disableAutomaticRetries().disableConnectionState().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build());
    }
}

