/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import eu.dnetlib.data.mdstore.plugins.MdRecordPlugin;
import eu.dnetlib.data.mdstore.plugins.objects.CnrCollection;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.utils.HttpFetcher;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class EnrichCollectionPlugin
extends MdRecordPlugin {
    private Map<String, CnrCollection> colls = new HashMap<String, CnrCollection>();
    private static final Log log = LogFactory.getLog(EnrichCollectionPlugin.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected void reconfigure(Map<String, String> params) {
        params.entrySet().forEach(e -> log.debug((Object)String.format("******************* %s -> %s", e.getKey(), e.getValue())));
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(params.get("dsId"));
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            String baseUrl = doc.valueOf("//INTERFACE[@id='" + params.get("dsInterface") + "']/BASE_URL").trim();
            this.colls.clear();
            this.colls.putAll(this.listOaiCollections(baseUrl, null).stream().map(this::createCollection).filter(Objects::nonNull).distinct().collect(Collectors.toMap(CnrCollection::getCode, o -> o)));
        }
        catch (Throwable e2) {
            log.error((Object)"Error evaluating ListSets", e2);
            throw new RuntimeException("Error evaluating ListSets", e2);
        }
    }

    @Override
    protected boolean updateRecord(String recordId, MdRecord record) {
        log.debug((Object)("Updating record: " + recordId));
        for (CnrCollection c : record.getInCollections()) {
            if (!this.colls.containsKey(c.getCode())) continue;
            c.setName(this.colls.get(c.getCode()).getName());
            c.setAcronym(this.colls.get(c.getCode()).getAcronym());
        }
        log.debug((Object)("Record updated: " + recordId));
        return true;
    }

    private List<Node> listOaiCollections(String baseUrl, String token) {
        SAXReader reader = new SAXReader();
        try {
            StringWriter listSetsUrl = new StringWriter();
            listSetsUrl.append(baseUrl);
            listSetsUrl.append("?verb=ListSets");
            if (token != null) {
                listSetsUrl.append("&resumptionToken=");
                listSetsUrl.append(token);
            }
            log.info((Object)("ListSets: " + listSetsUrl));
            String s = HttpFetcher.fetch(listSetsUrl.toString());
            Document doc = reader.read((Reader)new StringReader(s));
            List list = doc.selectNodes("//*[local-name() = 'ListSets']/*[local-name() = 'set']");
            String nextToken = doc.valueOf("//*[local-name() = 'resumptionToken']").trim();
            if (StringUtils.isNotBlank((CharSequence)nextToken)) {
                list.addAll(this.listOaiCollections(baseUrl, nextToken));
            }
            return list;
        }
        catch (URISyntaxException | DocumentException e) {
            log.error((Object)("Error listing sets from url: " + baseUrl), e);
            try {
                Document doc = reader.read(this.getClass().getResourceAsStream("ListSets.xml"));
                return doc.selectNodes("//*[local-name() = 'ListSets']/*[local-name() = 'set']");
            }
            catch (DocumentException e1) {
                log.error((Object)"Error listing sets from local file", (Throwable)e1);
                return new ArrayList<Node>();
            }
        }
    }

    private CnrCollection createCollection(Node n) {
        CnrCollection c = new CnrCollection();
        String code = n.valueOf("./*[local-name() = 'setSpec']").trim();
        c.setCode(n.valueOf("./*[local-name() = 'setSpec']").trim());
        if (code.equalsIgnoreCase("openaire")) {
            c.setAcronym("openaire");
            c.setName("Openaire Collection");
        } else {
            String desc = n.valueOf("./*[local-name() = 'setDescription']").trim();
            if (StringUtils.isNotBlank((CharSequence)desc)) {
                Matcher m = Pattern.compile("^Prodotti della ricerca di (.+) \\- (.+)$").matcher(desc);
                if (m.matches()) {
                    c.setAcronym(m.group(1));
                    c.setName(m.group(2));
                } else {
                    c.setAcronym(desc);
                    c.setName(desc);
                }
            } else {
                String name = n.valueOf("./*[local-name() = 'setName']").trim();
                c.setAcronym(name);
                c.setName(name);
            }
        }
        return c;
    }

    @Override
    protected void resetConfiguration() {
        this.colls.clear();
    }
}

