/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import eu.dnetlib.data.mdstore.plugins.MdRecordPlugin;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.Project;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class EnrichProjectsPlugin
extends MdRecordPlugin {
    private static final Log log = LogFactory.getLog(EnrichProjectsPlugin.class);
    @Value(value="${plugin.enrich.projects.openaire.url}")
    private String baseUrl;
    private Map<String, Project> mapProjects = new HashMap<String, Project>();

    @Override
    protected void reconfigure(Map<String, String> params) {
        log.debug((Object)"Cleaning projects cache");
        this.mapProjects.clear();
    }

    @Override
    protected void resetConfiguration() {
        log.debug((Object)"Cleaning projects cache");
        this.mapProjects.clear();
    }

    @Override
    protected boolean updateRecord(String recordId, MdRecord record) {
        log.debug((Object)("Found " + record.getProjects().size() + " projects"));
        if (record.getProjects().isEmpty()) {
            return false;
        }
        LinkedHashSet<Project> list = new LinkedHashSet<Project>();
        for (Project p : record.getProjects()) {
            if (StringUtils.isNotBlank((CharSequence)p.getInfoId())) {
                list.add(this.findEnrichedProject(Project.newInstance(p.getInfoId())));
                continue;
            }
            if (this.allValidParams(p.getFunder(), p.getProgram(), p.getCode())) {
                list.add(this.findEnrichedProject(p));
                continue;
            }
            list.add(p);
        }
        log.debug((Object)("Processed " + list.size() + " projects"));
        if (list.isEmpty()) {
            return false;
        }
        record.getProjects().clear();
        record.getProjects().addAll(list);
        return true;
    }

    private boolean allValidParams(String ... params) {
        for (String s : params) {
            if (!StringUtils.isBlank((CharSequence)s) && !s.trim().contains(" ")) continue;
            return false;
        }
        return true;
    }

    private Project findEnrichedProject(Project simpleProject) {
        String s = simpleProject.getFunder() + "/" + simpleProject.getProgram() + "/" + simpleProject.getCode();
        if (!this.mapProjects.containsKey(s)) {
            Project project = this.resolveProject(s);
            this.mapProjects.put(s, project != null ? project : simpleProject);
        }
        return this.mapProjects.get(s);
    }

    private Project resolveProject(String s) {
        try {
            String[] arr = s.split("/");
            String url = String.format(this.baseUrl, arr[0], arr[1], arr[2]);
            return Project.newInstance(new URI(url));
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error resolving project: " + s), (Throwable)e);
            throw new RuntimeException("Error resolving project: " + s, e);
        }
    }
}

