/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.plugins.AbstractIstiMDStorePlugin;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class FilterMdRecordsPlugin
extends AbstractIstiMDStorePlugin {
    private static final Log log = LogFactory.getLog(FilterMdRecordsPlugin.class);

    @Override
    public final void process(MongoMDStore store, Map<String, String> params) throws MDStoreServiceException {
        String xpath = params.get("xpath");
        MongoCollection collPubs = store.getCollection();
        long valid = 0L;
        long skipped = 0L;
        SAXReader reader = new SAXReader();
        for (DBObject obj : collPubs.find()) {
            try {
                String recordId = obj.get("id").toString();
                Document doc = reader.read((Reader)new StringReader(obj.get("body").toString()));
                if (doc.selectNodes(xpath).isEmpty()) {
                    collPubs.deleteOne((Bson)new BasicDBObject("id", (Object)recordId));
                    ++skipped;
                    continue;
                }
                ++valid;
            }
            catch (DocumentException e) {
                log.warn((Object)"Problem parsing a mdstore record", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"***** Filtering records *****");
            log.debug((Object)("*     xpath: " + xpath));
            log.debug((Object)("*     valid: " + valid));
            log.debug((Object)("*   skipped: " + skipped));
            log.debug((Object)"*****************************");
        }
        this.touch(store);
    }
}

