<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  
	xmlns:oai="http://www.openarchives.org/OAI/2.0/" 
	xmlns:dc="http://purl.org/dc/elements/1.1/" 
	xmlns:oaire="http://namespace.openaire.eu/schema/oaire/"
	xmlns:datacite="http://datacite.org/schema/kernel-4"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:TransformationFunction="eu.dnetlib.data.collective.transformation.core.xsl.ext.TransformationFunctionProxy" 
	xmlns:dnet="eu.dnetlib.data.utils.XsltFunctions" 
	exclude-result-prefixes="xsl TransformationFunction dnet dc oaire datacite">
	
	<xsl:param name="varOfficialName" />

	<xsl:variable name="tf" select="TransformationFunction:getInstance()" />

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="//*[local-name() = 'header']/@status='deleted'">
				<xsl:message terminate="yes">record deleted, skip transformation.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="tmpRights" select="TransformationFunction:convertString($tf, .//datacite:rights/@rightsURI, 'AccessRights')" />
				<xsl:variable name="rights">
					<xsl:choose>
						<xsl:when test="$tmpRights and $tmpRights != 'UNKNOWN'">
							<xsl:value-of select="$tmpRights"/>
						</xsl:when>
						<xsl:when test=".//datacite:rights/@rightsURI">
							<xsl:value-of select=".//datacite:rights/@rightsURI"/>
						</xsl:when>
						<xsl:otherwise>
							Unknown
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
		
				<oai:record>
					<xsl:copy-of select="//*[local-name() = 'header']" />
					<oai:metadata>
						<record>
		
							<identifier>
								<xsl:value-of select="normalize-space(//dri:recordIdentifier)" />
							</identifier>
		
							<title>
								<xsl:value-of select="//datacite:title[1]" />
							</title>
		
							<creators>
								<xsl:for-each select="//datacite:creatorName">
									<xsl:variable name="orcid" select="../datacite:nameIdentifier[@nameIdentifierScheme='ORCID']"/>
									<xsl:for-each select="tokenize(dnet:cleanNames(.), '#')">
										<xsl:if test="string-length(.) &gt; 0">
											<creator>
												<xsl:if test="$orcid">
													<xsl:attribute name="orcid" select="$orcid"/>
												</xsl:if>
												<xsl:value-of select="." />
											</creator>
										</xsl:if>
									</xsl:for-each>
								</xsl:for-each>
							</creators>
		
							<publisher>
								<xsl:value-of select="//dc:publisher[1]" />
							</publisher>
		
							<subjects>
								<xsl:for-each select="//datacite:subject">
									<subject>
										<xsl:value-of select="." />
									</subject>
								</xsl:for-each>
							</subjects>
		
							<contributors>
								<xsl:for-each select="//datacite:contributorName">
									<xsl:for-each select="tokenize(., ',')">
										<contributor>
											<xsl:value-of select="normalize-space(.)" />
										</contributor>
									</xsl:for-each>
								</xsl:for-each>
							</contributors>
		
							
							<date>
								<xsl:value-of select="dnet:extractYear(//datacite:date[@dateType='Issued'][1])" />
							</date>
		
							<language>
								<xsl:value-of select="TransformationFunction:convertString($tf, //dc:language[1], 'Languages')" />
							</language>
		
							<type>
								<xsl:variable name="typeUri" select="//oaire:resourceType/@uri"/>
								<xsl:choose>
									<xsl:when test="$typeUri">
										<xsl:variable name="resType" select="TransformationFunction:convertString($tf, $typeUri, 'IopTypologies')" />
										<xsl:choose>
											<xsl:when test="$resType">
												<xsl:value-of select="$resType" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$typeUri"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										Missing
									</xsl:otherwise>
								</xsl:choose>	
							</type>		
		
							<!-- TODO -->
							<xsl:choose>
								<xsl:when test="starts-with(normalize-space(//dri:repositoryId), '807f0d50-2dc9-447d-8914-b91c34cb5841')">
									<documentPage>
										<xsl:value-of select="concat('https://openportal.isti.cnr.it/doc?id=people______::', dnet:md5(normalize-space(//dri:recordIdentifier)))" />
									</documentPage>
								</xsl:when>
								<xsl:when test="starts-with(normalize-space(//dri:repositoryId), 'a58f6fed-ac2d-4cfe-a175-d809858b0eeb')">
									<documentPage>
										<xsl:value-of select="concat('https://openportal.ispc.cnr.it/doc?id=people______::', dnet:md5(normalize-space(//dri:recordIdentifier)))" />
									</documentPage>
								</xsl:when>
								<xsl:when test="starts-with(normalize-space(//dri:repositoryId), 'db0e729d-38d0-44e1-9750-80d3c048525d')">
									<documentPage>
										<xsl:value-of select="concat('https://openportal.ismar.cnr.it/doc?id=people______::', dnet:md5(normalize-space(//dri:recordIdentifier)))" />
									</documentPage>
								</xsl:when>
								<xsl:when test="starts-with(normalize-space(//dri:repositoryId), '5bdb0333-29f0-40c9-ad33-1fc4de6b2efa')">
									<documentPage>
										<xsl:value-of select="concat('https://openportal.ino.cnr.it/doc?id=people______::', dnet:md5(normalize-space(//dri:recordIdentifier)))" />
									</documentPage>
								</xsl:when>
							</xsl:choose>
							<!-- END TODO -->
							
							<urls>
								<xsl:for-each select="distinct-values(//datacite:identifier|//datacite:alternateIdentifier)">
									<xsl:choose>
										<xsl:when test="starts-with(., 'http') and contains(., 'handle') and contains(., '/20.500.14243/')">
											<url rights="{$rights}" hostedBy="CNR IRIS"><xsl:value-of select="."/></url>
										</xsl:when>
										<xsl:when test="starts-with(., 'http') and contains(., 'publications.cnr.it')">
											<url rights="Unknown" hostedBy="CNR ExploRA">
												<xsl:value-of select="." />
											</url>
										</xsl:when>
										<xsl:when test="starts-with(., 'http') and contains(., 'doi.org/')">
											<xsl:variable name="doi" select="dnet:cleanDoi(substring-after(., 'doi.org/'))" />
											<url rights="{$rights}" hostedBy="DOI Resolver">
												<xsl:value-of select="concat('https://dx.doi.org/', $doi)" />
											</url>
										</xsl:when>
										<xsl:when test="starts-with(., 'info:doi:')">
											<xsl:variable name="doi" select="dnet:cleanDoi(substring-after(., 'info:doi:'))" />
											<url rights="{$rights}" hostedBy="DOI Resolver">
												<xsl:value-of select="concat('https://dx.doi.org/', $doi)" />
											</url>
										</xsl:when>
										<xsl:otherwise>
											<xsl:if test="starts-with(., 'http')">
												<url rights="{$rights}" hostedBy="{dnet:serverName(.)}">
													<xsl:value-of select="." />
												</url>
											</xsl:if>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
								<xsl:for-each select="//oaire:file">
									<xsl:if test="starts-with(., 'http') and contains(., 'iris.cnr.it')">
										<url hostedBy="CNR IRIS">
											<xsl:variable name="fileRights" select="TransformationFunction:convertString($tf, @accessRightsURI, 'AccessRights')" />
											<xsl:attribute name="rights">
												<xsl:choose>
													<xsl:when test="$fileRights and $fileRights != 'UNKNOWN'">
														<xsl:value-of select="$fileRights"/>
													</xsl:when>
													<xsl:when test="@accessRightsURI">
														<xsl:value-of select="@accessRightsURI"/>
													</xsl:when>
													<xsl:otherwise>
														Unknown
													</xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<xsl:value-of select="." />
										</url>
									</xsl:if>
								</xsl:for-each>
							</urls>
		
							<dois>
								<xsl:for-each select="//datacite:identifier|//datacite:alternateIdentifier">
									<xsl:if test="starts-with(., 'info:doi:')">
										<xsl:variable name="doi" select="dnet:cleanDoi(substring-after(., 'info:doi:'))" />
										<xsl:if test="$doi">
											<doi>
												<xsl:value-of select="$doi" />
											</doi>
										</xsl:if>
									</xsl:if>
									<xsl:if test="starts-with(., 'http') and contains(., 'doi.org/')">
										<xsl:variable name="doi" select="dnet:cleanDoi(substring-after(., 'doi.org/'))" />
										<xsl:if test="$doi">
											<doi>
												<xsl:value-of select="$doi" />
											</doi>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</dois>
		
							<xsl:choose>
								<xsl:when test="//datacite:identifier[starts-with(., 'http') and not(contains(., '/www.cnr.it/')) and not(contains(., '/publications.cnr.it/'))] | //datacite:alternateIdentifier[starts-with(., 'http') and not(contains(., '/www.cnr.it/')) and not(contains(., '/publications.cnr.it/'))]">
									<bestRights>
										<xsl:value-of select="$rights" />
									</bestRights>
								</xsl:when>
								<xsl:when test="//datacite:identifier[starts-with(., 'info:doi:')]">
									<bestRights>
										<xsl:value-of select="$rights" />
									</bestRights>
								</xsl:when>
								<xsl:otherwise>
									<bestRights>Unknown</bestRights>
								</xsl:otherwise>
							</xsl:choose>
		
							<abstract>
								<xsl:value-of select="//dc:description[1]" />
							</abstract>
							
							<source>
								<xsl:choose>
									<xsl:when test="//dc:source[(string-length(.) > 10) and not(starts-with(., 'info:cnr-pdr/source'))]">
										<xsl:value-of select="//dc:source[(string-length(.) > 10) and not(starts-with(., 'info:cnr-pdr/source')) and position() = 1]" />
									</xsl:when>
									<xsl:when test="//oaire:citationTitle">
										<xsl:value-of select="//oaire:citationTitle"/>
										<xsl:if test="//oaire:citationVolume">
											<xsl:value-of select="concat(', vol. ', //oaire:citationVolume)"/>
											<xsl:if test="//oaire:citationIssue">
												<xsl:value-of select="concat(' (issue ', //oaire:citationIssue, ')')"/>
											</xsl:if>
										</xsl:if>
										<xsl:if test="//oaire:citationStartPage">
											<xsl:choose>
												<xsl:when test="//oaire:citationEndPage and //oaire:citationStartPage != //oaire:citationEndPage">
													<xsl:value-of select="concat(', pp. ', //oaire:citationStartPage ,'-', //oaire:citationEndPage )"/>		
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat(', p. ', //oaire:citationStartPage)"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:if>
										<xsl:if test="//oaire:citationConferencePlace">
											<xsl:value-of select="concat('. ', //oaire:citationConferencePlace)"/>
											<xsl:if test="//oaire:citationConferenceDate">
												<xsl:value-of select="concat(', ', //oaire:citationConferenceDate)"/>
											</xsl:if>
										</xsl:if>
									</xsl:when>
								</xsl:choose>
							</source>

							<projects>
								<xsl:for-each select="//oaire:fundingReference[./oaire:awardTitle]">
										<xsl:variable name="funder">
											<xsl:variable name="tmpFunder" select="TransformationFunction:convertString($tf, ./oaire:funderName, 'Funders')" />
											
											<xsl:choose>
												<xsl:when test="$tmpFunder and $tmpFunder != 'UNKNOWN'">
													<xsl:value-of select="$tmpFunder"/>
												</xsl:when>
												<xsl:when test="./oaire:funderName">
													<xsl:value-of select="./oaire:funderName"/>
												</xsl:when>
												<xsl:when test="./oaire:fundingStream">
													<xsl:variable name="tmpFunderByStream" select="TransformationFunction:convertString($tf, ./oaire:fundingStream, 'Funders')" />
													<xsl:choose>
														<xsl:when test="$tmpFunderByStream and $tmpFunderByStream != 'UNKNOWN'">
															<xsl:value-of select="$tmpFunderByStream"/>
														</xsl:when>
														<xsl:when test="./oaire:fundingStream">
															<xsl:value-of select="./oaire:fundingStream"/>
														</xsl:when>
														<xsl:otherwise>Unknown</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													Unknown
												</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
									
										<xsl:variable name="program">
											<xsl:variable name="tmpProgram" select="TransformationFunction:convertString($tf, ./oaire:fundingStream, 'FunderStreams')" />
											<xsl:choose>
												<xsl:when test="$tmpProgram and $tmpProgram != 'UNKNOWN'">
													<xsl:value-of select="$tmpProgram"/>
												</xsl:when>
												<xsl:when test="./oaire:fundingStream">
													<xsl:value-of select="./oaire:fundingStream"/>
												</xsl:when>
												<xsl:otherwise>
													Unknown
												</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
																
										<project>
											<infoId/>
											<openaireId />
											<code>
												<xsl:value-of select="normalize-space(./oaire:awardNumber)" />
											</code>
											<name>
												<xsl:value-of select="normalize-space(./oaire:awardTitle)" />
											</name>
											<acronym>
												<xsl:value-of select="normalize-space(./oaire:awardTitle)" />
											</acronym>
											<funder>
												<xsl:value-of select="normalize-space($funder)" />
											</funder>
											<program>
												<xsl:value-of select="normalize-space($program)" />
											</program>
											<jurisdiction />
										</project>
								</xsl:for-each>
							</projects>
												
							<cnrPersons>
								<xsl:for-each select="//datacite:creator">
									<xsl:if test="./*[local-name()='nameIdentifier']/@nameIdentifierScheme='IRIS' and ./*[local-name()='affiliation']='National Research Council'">
										<cnrPerson>
											<infoId><xsl:value-of select="concat('iris:', normalize-space(./*[local-name()='nameIdentifier' and @nameIdentifierScheme='IRIS']))" /></infoId>
											<name><xsl:value-of select="./datacite:creatorName" /></name>
											<xsl:if test="./datacite:nameIdentifier[@nameIdentifierScheme='ORCID']">
												<orcid><xsl:value-of select="./datacite:nameIdentifier[@nameIdentifierScheme='ORCID']"/></orcid>
											</xsl:if>
										</cnrPerson>
									</xsl:if>
								</xsl:for-each>
							</cnrPersons>
							
							<citations />
		
							<collections>
								<xsl:for-each select="//oai:setSpec[normalize-space(.) != 'openaire']">
									<inCollection>
										<code>
											<xsl:value-of select="normalize-space(.)" />
										</code>
										<name />
										<acronym />
									</inCollection>
								</xsl:for-each>
							</collections>
							
						</record>
		
					</oai:metadata>
				</oai:record>				
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
