<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    <xsl:output method="text"/>
    
    <xsl:variable name="sq">'</xsl:variable>
    
    <xsl:template match="/">
        <xsl:for-each select="//Result/item">
            <xsl:variable name="year" select="./anno"/>
            <xsl:for-each select="./personale/item[string-length(./matricola) = 0]">
                <xsl:variable name="name" select="replace(./nome, '''','\\''')"/>
                <xsl:variable name="surname" select="replace(./cognome, '''', '\\''')"/>
                <xsl:for-each select="./labs/item">
                    <xsl:variable name="gid" select="./sigla"/>
                    <xsl:value-of select="concat('INSERT INTO affiliations_temp_no_id(name,surname,gid,year) VALUES (' ,$sq, $name, $sq, ',', $sq, $surname, $sq, ',', $sq, $gid, $sq, ',', $year, ');&#xa;')"/>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:for-each>
        
    </xsl:template>
    
</xsl:stylesheet>
