package eu.dnetlib.data.mdstore.plugins.objects;

import java.util.LinkedHashSet;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(XmlAccessType.FIELD)
public class CnrPerson {

	@XmlElement(name = "infoId")
	private String id;
	@XmlElement(name = "name")
	private String name;
	@XmlElement(name = "orcid")
	private String orcid;

	@XmlElement(name = "affiliation")
	private Set<Affiliation> affiliations = new LinkedHashSet<>();

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public Set<Affiliation> getAffiliations() {
		return affiliations;
	}

	public void setAffiliations(final Set<Affiliation> affiliations) {
		this.affiliations = affiliations;
	}

	public String getOrcid() {
		return orcid;
	}

	public void setOrcid(final String orcid) {
		this.orcid = orcid;
	}

	@Override
	public int hashCode() {
		return id == null ? 0 : id.hashCode();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null) { return false; }
		if (getClass() != obj.getClass()) { return false; }
		final CnrPerson other = (CnrPerson) obj;
		if (id == null) {
			if (other.id != null) { return false; }
		} else if (!id.equals(other.id)) { return false; }
		return true;
	}

}
