package eu.dnetlib.data.mdstore.plugins.objects;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "record")
@XmlAccessorType(XmlAccessType.FIELD)
public class MdRecord {

	@XmlElement(name = "identifier")
	private String id;

	@XmlElement(name = "title")
	private String title;

	@XmlElementWrapper(name = "creators")
	@XmlElement(name = "creator")
	private Set<Author> creators = new LinkedHashSet<>();

	@XmlElement(name = "publisher")
	private String publisher;

	@XmlElementWrapper(name = "subjects")
	@XmlElement(name = "subject")
	private Set<String> subjects = new LinkedHashSet<>();

	@XmlElementWrapper(name = "contributors")
	@XmlElement(name = "contributor")
	private Set<String> contributors = new LinkedHashSet<>();

	@XmlElement(name = "date")
	private int date;

	@XmlElement(name = "language")
	private String language;

	@XmlElement(name = "type")
	private String type;

	@XmlElement(name = "documentPage")
	private String documentPage;

	@XmlElementWrapper(name = "urls")
	@XmlElement(name = "url")
	private Set<MyURL> urls = new TreeSet<>((u1, u2) -> {
		final String r1 = u1.getRights();
		final String r2 = u2.getRights();
		final int n1 = r1.equalsIgnoreCase("Open Access") ? 0 : r1.equalsIgnoreCase("Unknown") ? 2 : 1;
		final int n2 = r2.equalsIgnoreCase("Open Access") ? 0 : r2.equalsIgnoreCase("Unknown") ? 2 : 1;
		final int res = Integer.compare(n1, n2);
		if (res == 0) {
			final String url1 = u1.getUrl().replaceAll("https://", "http://").toLowerCase();
			final String url2 = u2.getUrl().replaceAll("https://", "http://").toLowerCase();
			return url1.compareTo(url2);
		} else {
			return res;
		}
	});

	@XmlElementWrapper(name = "dois")
	@XmlElement(name = "doi")
	private Set<String> dois = new LinkedHashSet<>();

	@XmlElement(name = "bestRights")
	private String bestRights;

	@XmlElement(name = "abstract")
	private String descriptionAbstract;

	@XmlElement(name = "source")
	private String source;

	@XmlElementWrapper(name = "projects")
	@XmlElement(name = "project")
	private Set<Project> projects = new TreeSet<>((p1, p2) -> p1.getName().compareTo(p2.getName()));

	@XmlElementWrapper(name = "cnrPersons")
	@XmlElement(name = "cnrPerson")
	private Set<CnrPerson> cnrPersons = new TreeSet<>((p1, p2) -> p1.getName().compareTo(p2.getName()));

	@XmlElementWrapper(name = "datasets")
	@XmlElement(name = "dataset")
	private Set<Dataset> datasets = new TreeSet<>((d1, d2) -> d1.getTitle().compareTo(d2.getTitle()));

	@XmlElementWrapper(name = "citations")
	@XmlElement(name = "citation")
	private Set<String> citations = new LinkedHashSet<>();

	@XmlElementWrapper(name = "collections")
	@XmlElement(name = "inCollection")
	private Set<CnrCollection> inCollections = new LinkedHashSet<>();

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public Set<Author> getCreators() {
		return creators;
	}

	public void setCreators(final Set<Author> creators) {
		this.creators = creators;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(final String publisher) {
		this.publisher = publisher;
	}

	public Set<String> getSubjects() {
		return subjects;
	}

	public void setSubjects(final Set<String> subjects) {
		this.subjects = subjects;
	}

	public Set<String> getContributors() {
		return contributors;
	}

	public void setContributors(final Set<String> contributors) {
		this.contributors = contributors;
	}

	public int getDate() {
		return date;
	}

	public void setDate(final int date) {
		this.date = date;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(final String language) {
		this.language = language;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getDocumentPage() {
		return documentPage;
	}

	public void setDocumentPage(final String documentPage) {
		this.documentPage = documentPage;
	}

	public Set<MyURL> getUrls() {
		return urls;
	}

	public void setUrls(final Set<MyURL> urls) {
		this.urls = urls;
	}

	public Set<String> getDois() {
		return dois;
	}

	public void setDois(final Set<String> dois) {
		this.dois = dois;
	}

	public String getBestRights() {
		return bestRights;
	}

	public void setBestRights(final String bestRights) {
		this.bestRights = bestRights;
	}

	public String getDescriptionAbstract() {
		return descriptionAbstract;
	}

	public void setDescriptionAbstract(final String descriptionAbstract) {
		this.descriptionAbstract = descriptionAbstract;
	}

	public String getSource() {
		return source;
	}

	public void setSource(final String source) {
		this.source = source;
	}

	public Set<Project> getProjects() {
		return projects;
	}

	public void setProjects(final Set<Project> projects) {
		this.projects = projects;
	}

	public Set<CnrPerson> getCnrPersons() {
		return cnrPersons;
	}

	public void setCnrPersons(final Set<CnrPerson> cnrPersons) {
		this.cnrPersons = cnrPersons;
	}

	public void setCnrPerson(final Set<CnrPerson> cnrPersons) {
		this.cnrPersons = cnrPersons;
	}

	public Set<Dataset> getDatasets() {
		return datasets;
	}

	public void setDatasets(final Set<Dataset> datasets) {
		this.datasets = datasets;
	}

	public Set<String> getCitations() {
		return citations;
	}

	public void setCitations(final Set<String> citations) {
		this.citations = citations;
	}

	public Set<CnrCollection> getInCollections() {
		return inCollections;
	}

	public void setInCollections(final Set<CnrCollection> inCollections) {
		this.inCollections = inCollections;
	}

}
