package eu.dnetlib.data.utils;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.data.mdstore.plugins.objects.Author;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;

public class CsvConverter {

	public static String asCsv(final MdRecord record) {

		final StringWriter sw = new StringWriter();
		sw.append(prepareValue(record.getId()));
		sw.append("\t");
		sw.append(prepareValue(record.getTitle()));
		sw.append("\t");
		sw.append(prepareValue(record.getCreators()));
		sw.append("\t");
		sw.append(prepareValue(record.getPublisher()));
		sw.append("\t");
		sw.append(prepareValue(record.getType()));
		sw.append("\t");
		sw.append(prepareValue("" + record.getDate()));
		sw.append("\t");
		sw.append(prepareValue(record.getDois()));
		sw.append("\t");
		sw.append(prepareValue(record.getSource()));
		sw.append("\t");
		sw.append(prepareValue(record.getDocumentPage()));

		return sw.toString();
	}

	private static CharSequence prepareValue(final Set<Author> list) {
		return list.stream()
				.map(Author::getName)
				.map(CsvConverter::prepareValue)
				.filter(StringUtils::isNotBlank)
				.collect(Collectors.joining(", "));
	}

	private static String prepareValue(final Collection<String> list) {
		return list.stream()
				.map(CsvConverter::prepareValue)
				.filter(StringUtils::isNotBlank)
				.collect(Collectors.joining(", "));
	}

	private static String prepareValue(final String s) {
		return s == null ? ""
				: s.replaceAll("\\n", " ")
						.replaceAll("\\t", " ")
						.replaceAll("\\s+", " ")
						.replaceAll("\\p{C}", "?") // Unprintable chars
						.trim();
	}
}
