/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins.objects;

import eu.dnetlib.data.utils.HttpFetcher;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Project {
    @XmlElement(name="infoId")
    private String infoId;
    @XmlElement(name="openaireId")
    private String openaireId;
    @XmlElement(name="code")
    private String code;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="acronym")
    private String acronym;
    @XmlElement(name="funder")
    private String funder;
    @XmlElement(name="program")
    private String program;
    @XmlElement(name="jurisdiction")
    private String jurisdiction;
    private static final Log log = LogFactory.getLog(Project.class);
    private static final String PROJECT_REGEX = "info:eu-repo\\/grantAgreement\\/(.*)\\/(.*)\\/(.*)\\/(.*)\\/(.*)\\/(.*)";

    public static Project newInstance(URI url) {
        try {
            SAXReader reader = new SAXReader();
            String s = HttpFetcher.fetch(url);
            Document doc = reader.read((Reader)new StringReader(s));
            String openaireId = doc.valueOf("//*[local-name()='objIdentifier']");
            if (StringUtils.isBlank((CharSequence)openaireId)) {
                log.warn((Object)("Project not found using OpenAIRE API, url: " + url));
                return null;
            }
            String code = doc.valueOf("//code");
            String name = doc.valueOf("//title");
            String acronym = doc.valueOf("//acronym");
            String funder = doc.valueOf("//funder/shortname");
            String program = doc.valueOf("//funding_level_0/name");
            String jurisdiction = doc.valueOf("//funder/jurisdiction");
            return new Project(openaireId, code, name, acronym, funder, program, jurisdiction);
        }
        catch (DocumentException e) {
            log.error((Object)("Error parsing document from url " + url));
            throw new RuntimeException(e);
        }
    }

    public static Project newInstance(String infoId) {
        Pattern pattern = Pattern.compile(PROJECT_REGEX);
        Matcher matcher = pattern.matcher(infoId);
        if (matcher.find()) {
            String openaireId = "";
            String funder = matcher.group(1).replaceAll("%2F", "/");
            String program = matcher.group(2).replaceAll("%2F", "/");
            String code = matcher.group(3).replaceAll("%2F", "/");
            String jurisdiction = matcher.group(4).replaceAll("%2F", "/");
            String name = (String)StringUtils.defaultIfBlank((CharSequence)matcher.group(5).replaceAll("%2F", "/"), (CharSequence)(funder + "/" + program + "/" + code));
            String acronym = ((String)StringUtils.defaultIfBlank((CharSequence)matcher.group(6), (CharSequence)name)).replaceAll("%2F", "/");
            if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)program) && StringUtils.isNotEmpty((CharSequence)funder)) {
                return new Project("", code, name, acronym, funder, program, jurisdiction);
            }
        }
        log.warn((Object)("Invalid project ID: " + infoId));
        return null;
    }

    public static boolean isValid(String infoId) {
        return Project.newInstance(infoId) != null;
    }

    public Project() {
    }

    public Project(String openaireId, String code, String name, String acronym, String funder, String program, String jurisdiction) {
        this.openaireId = openaireId;
        this.code = code;
        this.name = name;
        this.acronym = acronym;
        this.funder = funder;
        this.program = program;
        this.jurisdiction = jurisdiction;
    }

    public String getOpenaireId() {
        return this.openaireId;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public String getFunder() {
        return this.funder;
    }

    public String getProgram() {
        return this.program;
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public boolean match(String infoId) {
        Project p = Project.newInstance(infoId);
        return p != null && this.funder.equals(p.funder) && this.program.equals(p.program) && this.code.equals(p.code);
    }

    public String toString() {
        return "Project [openaireId=" + this.openaireId + ", code=" + this.code + ", name=" + this.name + ", acronym=" + this.acronym + ", funder=" + this.funder + ", program=" + this.program + ", jurisdiction=" + this.jurisdiction + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.funder == null ? 0 : this.funder.hashCode());
        result = 31 * result + (this.program == null ? 0 : this.program.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.funder == null ? other.funder != null : !this.funder.equals(other.funder)) {
            return false;
        }
        return !(this.program == null ? other.program != null : !this.program.equals(other.program));
    }

    public String getInfoId() {
        return this.infoId;
    }

    public void setInfoId(String infoId) {
        this.infoId = infoId;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public void setFunder(String funder) {
        this.funder = funder;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }
}

