/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class PatchCinecaIdsJobNode
extends SimpleJobNode {
    @Autowired
    private ResultSetFactory resultSetFactory;
    private Resource idMapFile;
    private String inputEprParam;
    private String outputEprParam;
    public static final String cinecaOaiPrefix = "oai:iris.cnr.it:";
    public static final String peopleOaiPrefix = "oai:it.cnr:prodotti:";
    public static final String peopleNamespacePrefix = "people______::";
    private static final Namespace ISTI_NS = new Namespace("isti", "http://openportal.isti.cnr.it");
    private static final Namespace DRI_NS = new Namespace("dri", "http://www.driver-repository.eu/namespace/dri");
    private static final Log log = LogFactory.getLog(PatchCinecaIdsJobNode.class);

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("Passed rs is null");
        }
        Map<String, String> idMap = this.loadMap(this.idMapFile);
        log.info((Object)("potential mapped ids: " + idMap.size()));
        ResultSet rsOut = this.resultSetFactory.map(rsIn, String.class, xml -> this.patchId((String)xml, idMap));
        env.setAttribute(this.outputEprParam, (Object)rsOut);
        return Arc.DEFAULT_ARC;
    }

    /*
     * Exception decompiling
     */
    protected Map<String, String> loadMap(Resource mapResource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String patchId(String xml, Map<String, String> idMap) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Element header = (Element)doc.selectSingleNode("//*[local-name() = 'header']");
            for (Object o : header.selectNodes("./*[local-name() = 'identifier']")) {
                String peopleId;
                Node n = (Node)o;
                String oldValue = n.getText().trim();
                if (!oldValue.startsWith(cinecaOaiPrefix) || !StringUtils.isNotBlank((CharSequence)(peopleId = idMap.get(StringUtils.substringAfter((String)oldValue, (String)cinecaOaiPrefix))))) continue;
                String newValue = peopleOaiPrefix + peopleId;
                n.setText(newValue);
                header.addElement(new QName("objIdentifier", DRI_NS)).setText(peopleNamespacePrefix + Hashing.md5((String)newValue));
                header.addElement(new QName("hiddenIdentifier", ISTI_NS)).setText(oldValue);
                log.debug((Object)("* MAPPED ID: " + oldValue + " -> " + newValue));
            }
            return doc.asXML();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public Resource getIdMapFile() {
        return this.idMapFile;
    }

    @Required
    public void setIdMapFile(Resource idMapFile) {
        this.idMapFile = idMapFile;
    }
}

