package eu.dnetlib.data.mdstore.plugins;

import java.io.StringReader;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.dom4j.io.SAXReader;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;

import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecordConvertUtils;
import eu.dnetlib.data.utils.BibTexConverter;
import eu.dnetlib.data.utils.CsvConverter;
import eu.dnetlib.rmi.data.MDStoreServiceException;

public class FreezeMDStorePlugin extends AbstractIstiMDStorePlugin {

	private static final Log log = LogFactory.getLog(FreezeMDStorePlugin.class);

	@Override
	protected void process(final MongoMDStore store, final Map<String, String> params) throws MDStoreServiceException {

		final MongoCollection<Document> freezeColl = getDao().getDb().getCollection(params.get("collection"));

		freezeColl.drop();

		final Gson gson = new Gson();
		final SAXReader reader = new SAXReader();

		for (final DBObject obj : store.getCollection().find()) {
			final String id = obj.get("id").toString();
			try {
				final Document doc = new Document();

				final String xml = reader.read(new StringReader(obj.get("body").toString()))
						.selectSingleNode("//*[local-name() = 'metadata']/record")
						.asXML();

				final MdRecord record = MdRecordConvertUtils.fromString(xml);
				doc.append("id", id);
				doc.append("xml", xml);
				doc.append("bibtex", BibTexConverter.asBibTex(record));
				doc.append("csv", CsvConverter.asCsv(record));
				doc.append("json", gson.toJson(record));

				freezeColl.insertOne(doc);
			} catch (final Exception e) {
				log.error("Error saving record " + id, e);
			}
		}

		freezeColl.createIndex(new BasicDBObject("id", 1));

	}

}
