/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins.objects;

import eu.dnetlib.data.mdstore.plugins.objects.Author;
import eu.dnetlib.data.mdstore.plugins.objects.CnrCollection;
import eu.dnetlib.data.mdstore.plugins.objects.CnrPerson;
import eu.dnetlib.data.mdstore.plugins.objects.Dataset;
import eu.dnetlib.data.mdstore.plugins.objects.MyURL;
import eu.dnetlib.data.mdstore.plugins.objects.Project;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="record")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MdRecord {
    @XmlElement(name="identifier")
    private String id;
    @XmlElement(name="title")
    private String title;
    @XmlElementWrapper(name="creators")
    @XmlElement(name="creator")
    private Set<Author> creators = new LinkedHashSet<Author>();
    @XmlElement(name="publisher")
    private String publisher;
    @XmlElementWrapper(name="subjects")
    @XmlElement(name="subject")
    private Set<String> subjects = new LinkedHashSet<String>();
    @XmlElementWrapper(name="contributors")
    @XmlElement(name="contributor")
    private Set<String> contributors = new LinkedHashSet<String>();
    @XmlElement(name="date")
    private int date;
    @XmlElement(name="language")
    private String language;
    @XmlElement(name="type")
    private String type;
    @XmlElement(name="documentPage")
    private String documentPage;
    @XmlElementWrapper(name="urls")
    @XmlElement(name="url")
    private Set<MyURL> urls = new TreeSet<MyURL>((u1, u2) -> {
        int n1;
        String r1 = u1.getRights();
        String r2 = u2.getRights();
        int n = r1.equalsIgnoreCase("Open Access") ? 0 : (n1 = r1.equalsIgnoreCase("Unknown") ? 2 : 1);
        int n2 = r2.equalsIgnoreCase("Open Access") ? 0 : (r2.equalsIgnoreCase("Unknown") ? 2 : 1);
        int res = Integer.compare(n1, n2);
        if (res == 0) {
            String url1 = u1.getUrl().replaceAll("https://", "http://").toLowerCase();
            String url2 = u2.getUrl().replaceAll("https://", "http://").toLowerCase();
            return url1.compareTo(url2);
        }
        return res;
    });
    @XmlElementWrapper(name="dois")
    @XmlElement(name="doi")
    private Set<String> dois = new LinkedHashSet<String>();
    @XmlElement(name="bestRights")
    private String bestRights;
    @XmlElement(name="abstract")
    private String descriptionAbstract;
    @XmlElement(name="source")
    private String source;
    @XmlElementWrapper(name="projects")
    @XmlElement(name="project")
    private Set<Project> projects = new TreeSet<Project>((p1, p2) -> p1.getName().compareTo(p2.getName()));
    @XmlElementWrapper(name="cnrPersons")
    @XmlElement(name="cnrPerson")
    private Set<CnrPerson> cnrPersons = new TreeSet<CnrPerson>((p1, p2) -> p1.getName().compareTo(p2.getName()));
    @XmlElementWrapper(name="datasets")
    @XmlElement(name="dataset")
    private Set<Dataset> datasets = new TreeSet<Dataset>((d1, d2) -> d1.getTitle().compareTo(d2.getTitle()));
    @XmlElementWrapper(name="citations")
    @XmlElement(name="citation")
    private Set<String> citations = new LinkedHashSet<String>();
    @XmlElementWrapper(name="collections")
    @XmlElement(name="inCollection")
    private Set<CnrCollection> inCollections = new LinkedHashSet<CnrCollection>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Set<Author> getCreators() {
        return this.creators;
    }

    public void setCreators(Set<Author> creators) {
        this.creators = creators;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Set<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Set<String> subjects) {
        this.subjects = subjects;
    }

    public Set<String> getContributors() {
        return this.contributors;
    }

    public void setContributors(Set<String> contributors) {
        this.contributors = contributors;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDocumentPage() {
        return this.documentPage;
    }

    public void setDocumentPage(String documentPage) {
        this.documentPage = documentPage;
    }

    public Set<MyURL> getUrls() {
        return this.urls;
    }

    public void setUrls(Set<MyURL> urls) {
        this.urls = urls;
    }

    public Set<String> getDois() {
        return this.dois;
    }

    public void setDois(Set<String> dois) {
        this.dois = dois;
    }

    public String getBestRights() {
        return this.bestRights;
    }

    public void setBestRights(String bestRights) {
        this.bestRights = bestRights;
    }

    public String getDescriptionAbstract() {
        return this.descriptionAbstract;
    }

    public void setDescriptionAbstract(String descriptionAbstract) {
        this.descriptionAbstract = descriptionAbstract;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    public Set<CnrPerson> getCnrPersons() {
        return this.cnrPersons;
    }

    public void setCnrPersons(Set<CnrPerson> cnrPersons) {
        this.cnrPersons = cnrPersons;
    }

    public void setCnrPerson(Set<CnrPerson> cnrPersons) {
        this.cnrPersons = cnrPersons;
    }

    public Set<Dataset> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Set<Dataset> datasets) {
        this.datasets = datasets;
    }

    public Set<String> getCitations() {
        return this.citations;
    }

    public void setCitations(Set<String> citations) {
        this.citations = citations;
    }

    public Set<CnrCollection> getInCollections() {
        return this.inCollections;
    }

    public void setInCollections(Set<CnrCollection> inCollections) {
        this.inCollections = inCollections;
    }
}

