package eu.dnetlib.data.mdstore.plugins.objects;

import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(XmlAccessType.FIELD)
public class CnrCollection {

	@XmlElement(name = "code")
	public String code;
	@XmlElement(name = "name")
	public String name;
	@XmlElement(name = "acronym")
	public String acronym;

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public String getAcronym() {
		return acronym;
	}

	public void setAcronym(final String acronym) {
		this.acronym = acronym;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public int hashCode() {
		return Objects.hash(code);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null) { return false; }
		if (!(obj instanceof CnrCollection)) { return false; }
		final CnrCollection other = (CnrCollection) obj;
		return Objects.equals(code, other.code);
	}
}
