/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.plugins.Counter;
import eu.dnetlib.data.mdstore.plugins.GenericDoiMdstorePlugin;
import eu.dnetlib.data.mdstore.plugins.objects.Dataset;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.dli.DliEntity;
import eu.dnetlib.data.mdstore.plugins.objects.dli.DliIdentifier;
import eu.dnetlib.data.mdstore.plugins.objects.dli.DliRelation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EnrichDatasetsPlugin
extends GenericDoiMdstorePlugin {
    private static final Log log = LogFactory.getLog(EnrichDatasetsPlugin.class);
    private static final Gson gson = new Gson();
    @Value(value="${plugin.enrich.dataset.dli.url}")
    private String baseUrl;
    @Autowired
    private MongoClient mongoClient;
    private Counter enrichDatasetsCounter = new Counter();

    @Override
    protected URI prepareURI(String doi) throws URISyntaxException {
        return new URI(String.format(this.baseUrl, doi));
    }

    @Override
    protected void reconfigure(Map<String, String> params) {
        this.enrichDatasetsCounter.reset();
    }

    @Override
    protected void resetConfiguration() {
        log.info((Object)("***** Openaire Enrichment - datasets  : " + this.enrichDatasetsCounter));
        this.enrichDatasetsCounter.reset();
    }

    @Override
    protected MongoCollection<Document> getCacheCollection() {
        return this.mongoClient.getDatabase("API_CACHES").getCollection("DATASETS_API_CACHE");
    }

    @Override
    protected boolean updateDocument(MdRecord doc, String response) {
        doc.getDatasets().clear();
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        List rels = (List)gson.fromJson(response, new TypeToken<List<DliRelation>>(){}.getType());
        for (DliRelation rel : rels) {
            datasets.addAll(this.findRelatedDatasets(rel.getSource()));
            datasets.addAll(this.findRelatedDatasets(rel.getTarget()));
        }
        if (datasets.isEmpty()) {
            return false;
        }
        doc.getDatasets().addAll(datasets);
        this.enrichDatasetsCounter.incrementAfter(doc.getDatasets().size());
        return true;
    }

    private List<Dataset> findRelatedDatasets(DliEntity entity) {
        ArrayList<Dataset> res = new ArrayList<Dataset>();
        if (entity.getObjectType().equalsIgnoreCase("dataset")) {
            String title = entity.getTitle();
            for (DliIdentifier id : entity.getIdentifiers()) {
                if (!id.getSchema().equalsIgnoreCase("doi") || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id.getIdentifier()}) || !StringUtils.isNotBlank((CharSequence)title)) continue;
                res.add(new Dataset(id.getIdentifier(), title));
            }
        }
        return res;
    }
}

