package eu.dnetlib.data.mdstore.plugins.objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(XmlAccessType.FIELD)
public class Affiliation {

	@XmlAttribute(name = "code")
	private String code;

	@XmlAttribute(name = "type")
	private String type;

	@XmlAttribute(name = "groupAcronym")
	private String groupAcronym;

	@XmlAttribute(name = "group")
	private String group;

	public Affiliation() {}

	public Affiliation(final String code, final String type, final String groupAcronym, final String group) {
		super();
		this.code = code;
		this.type = type;
		this.groupAcronym = groupAcronym;
		this.group = group;
	}

	public String getGroupAcronym() {
		return groupAcronym;
	}

	public void setGroupAcronym(final String groupAcronym) {
		this.groupAcronym = groupAcronym;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(final String group) {
		this.group = group;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	@Override
	public int hashCode() {
		return groupAcronym == null ? 0 : groupAcronym.hashCode();

	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null) { return false; }
		if (getClass() != obj.getClass()) { return false; }
		final Affiliation other = (Affiliation) obj;
		if (groupAcronym == null) {
			if (other.groupAcronym != null) { return false; }
		} else if (!groupAcronym.equals(other.groupAcronym)) { return false; }
		return true;
	}

}
