/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import eu.dnetlib.data.db.DbGroup;
import eu.dnetlib.data.db.DbPerson;
import eu.dnetlib.data.db.DbPersonsDao;
import eu.dnetlib.data.mdstore.plugins.MdRecordPlugin;
import eu.dnetlib.data.mdstore.plugins.objects.CnrPerson;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.utils.XsltFunctions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EnrichCnrPersonsPlugin
extends MdRecordPlugin {
    private static final Log log = LogFactory.getLog(EnrichCnrPersonsPlugin.class);
    public static final DbGroup UNKNOWN_GROUP = new DbGroup("UNKNOWN", "UNKNOWN", "UNKNOWN");
    public static final String DNET_PERSON_PREFIX = "dnet:pers:";
    @Autowired
    private DbPersonsDao dao;
    private Map<String, String> masters = new HashMap<String, String>();
    private Map<String, DbPerson> affiliations = new HashMap<String, DbPerson>();
    private Set<String> newRegistered = new HashSet<String>();

    @Override
    protected void reconfigure(Map<String, String> params) {
        String affiliation = params.get("affiliation");
        this.newRegistered.clear();
        this.masters = this.dao.obtainRawPersonToMasterRels();
        this.affiliations = this.dao.listPersonsWithAffiliations().stream().filter(p -> {
            for (Set<DbGroup> groups : p.getGroups().values()) {
                for (DbGroup g : groups) {
                    if (!g.getId().equals(affiliation)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toMap(DbPerson::getId, a -> a));
    }

    @Override
    protected void resetConfiguration() {
        this.masters.clear();
        this.affiliations.clear();
    }

    @Override
    protected boolean updateRecord(String recordId, MdRecord doc) {
        LinkedHashSet<CnrPerson> newCnrPersons = new LinkedHashSet<CnrPerson>();
        for (CnrPerson old : doc.getCnrPersons()) {
            Pattern pattern = Pattern.compile("info:cnr-pdr\\/author\\/(.+)\\/(.+)\\/(.+)");
            Matcher matcher = pattern.matcher(old.getId());
            CnrPerson ncp = matcher.find() ? this.processPerson(matcher.group(1), matcher.group(2), matcher.group(3), null, null) : (StringUtils.isNotBlank((CharSequence)old.getName()) ? this.processPerson(old.getId(), old.getName(), "", null, old.getOrcid()) : null);
            if (ncp == null) continue;
            if (StringUtils.isNotBlank((CharSequence)ncp.getOrcid())) {
                doc.getCreators().stream().filter(c -> EnrichCnrPersonsPlugin.isSamePerson(ncp.getName(), c.getName())).filter(c -> StringUtils.isBlank((CharSequence)c.getOrcid())).findFirst().ifPresent(c -> c.setOrcid(ncp.getOrcid()));
            }
            newCnrPersons.add(ncp);
        }
        doc.setCnrPersons(newCnrPersons);
        return true;
    }

    private CnrPerson processPerson(String code, String surname, String name, String suffix, String orcid) {
        DbPerson p;
        if (this.newRegistered.contains(code)) {
            return null;
        }
        DbPerson dbPerson = p = code.startsWith(DNET_PERSON_PREFIX) ? this.affiliations.get(code) : this.affiliations.get(this.masters.get(code));
        if (p == null) {
            log.warn((Object)("Person not found, code: " + code));
            this.dao.registerRawPerson(code, XsltFunctions.capitalize(name), XsltFunctions.capitalize(surname), suffix, orcid);
            this.newRegistered.add(code);
            return null;
        }
        CnrPerson cp = new CnrPerson();
        cp.setId(p.getId());
        cp.setName(p.getFullname());
        cp.setOrcid(p.getOrcid());
        return cp;
    }

    protected static boolean isSamePerson(String fullname, String other) {
        String surname = StringUtils.substringBefore((String)fullname, (String)",").trim().toLowerCase();
        String name = StringUtils.substringAfter((String)fullname, (String)",").trim().toLowerCase();
        List initials1 = Arrays.stream(name.split(" ")).map(String::trim).filter(StringUtils::isNotBlank).map(s -> Character.valueOf(s.charAt(0))).collect(Collectors.toList());
        if (initials1.isEmpty()) {
            return false;
        }
        if (!other.toLowerCase().startsWith(surname)) {
            return false;
        }
        String[] parts = StringUtils.substringAfter((String)other.toLowerCase(), (String)surname).replaceAll("\\,", " ").replaceAll("\\.", " ").split(" ");
        List initials2 = Arrays.stream(parts).map(String::trim).filter(StringUtils::isNotBlank).map(s -> Character.valueOf(s.charAt(0))).collect(Collectors.toList());
        if (initials2.isEmpty()) {
            return false;
        }
        if (initials1.containsAll(initials2)) {
            return true;
        }
        return initials2.containsAll(initials1);
    }
}

