/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.plugins.AbstractIstiMDStorePlugin;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecordConvertUtils;
import eu.dnetlib.data.utils.BibTexConverter;
import eu.dnetlib.data.utils.CsvConverter;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.dom4j.io.SAXReader;

public class FreezeMDStorePlugin
extends AbstractIstiMDStorePlugin {
    private static final Log log = LogFactory.getLog(FreezeMDStorePlugin.class);

    @Override
    protected void process(MongoMDStore store, Map<String, String> params) throws MDStoreServiceException {
        MongoCollection freezeColl = this.getDao().getDb().getCollection(params.get("collection"));
        freezeColl.drop();
        Gson gson = new Gson();
        SAXReader reader = new SAXReader();
        for (DBObject obj : store.getCollection().find()) {
            String id = obj.get("id").toString();
            try {
                Document doc = new Document();
                String xml = reader.read((Reader)new StringReader(obj.get("body").toString())).selectSingleNode("//*[local-name() = 'metadata']/record").asXML();
                MdRecord record = MdRecordConvertUtils.fromString(xml);
                doc.append("id", (Object)id);
                doc.append("xml", (Object)xml);
                doc.append("bibtex", (Object)BibTexConverter.asBibTex(record));
                doc.append("csv", (Object)CsvConverter.asCsv(record));
                doc.append("json", (Object)gson.toJson((Object)record));
                freezeColl.insertOne((Object)doc);
            }
            catch (Exception e) {
                log.error((Object)("Error saving record " + id), (Throwable)e);
            }
        }
        freezeColl.createIndex((Bson)new BasicDBObject("id", (Object)1));
    }
}

