$common/master( header={
	<script type="text/javascript" src="../resources/js/angular-1.4.8.min.js"></script>
	<script type="text/javascript" src="../resources/js/portal/affiliations.js"></script>
}, onLoad={}, body={
	<div ng-app="affiliationsUI" ng-controller="affiliationsCtrl">
		<div class="col-xs-12 col-md-8 col-lg-6">
				
			<input type="text" class="form-control" ng-model="personFilter" placeholder="Filter by name...">
			<br />

			<div class="panel panel-default" ng-repeat="aff in affiliations | filter: personFilter">
				<div class="panel-heading">
					<h3 class="panel-title text-center">{{aff.name}}</h3>
				</div>
				<table class="table table-condensed table-striped">
					<tbody ng-repeat="p in aff.persons">
						<tr ng-repeat="(year, groups) in p.affiliations">
							<th class="col-xs-3"><span ng-if="\$first">{{p.id}}</span></th>
							<td class="col-xs-1">{{year}}</td>
							<td>
								<span ng-repeat="g in groups">
									<span ng-if="g.id != 'UNKNOWN'">{{g.name}} ({{g.id}})</span>
									<button type="button" class="btn btn-xs btn-danger"
										ng-if="g.id == 'UNKNOWN'"
										ng-click="prepareTempAffiliation(p.id, aff.name, year)"
										data-toggle="modal"
										data-target="#newAffiliationModal">edit</button>
									<span class="label label-default pull-right" ng-class="{
										'label-info'    : g.type == 'Laboratorio',
										'label-success' : g.type == 'Servizio',
										'label-danger'  : g.type == 'UNKNOWN'
									}">{{g.type}}</span>
									<br />
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
			
		<div class="modal fade" id="newAffiliationModal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
						<h4 class="modal-title">New affiliation</h4>
					</div>
					<div class="modal-body">
						<form>
							<div class="form-group">
								<label>Person ID</label>
								 <p class="form-control-static">{{tempAffiliation.pid}}</p>
							</div>
							<div class="form-group">
								<label>Person Name</label>
								 <p class="form-control-static">{{tempAffiliation.pname}}</p>
							</div>
							<div class="form-group">
								<label>Year</label>
								 <p class="form-control-static">{{tempAffiliation.year}}</p>
							</div>
							<div class="form-group">
								<label>Group</label>
								<select class="form-control" ng-model="tempAffiliation.gid" ng-options="g.id as g.name group by g.type for g in groups"></select>
							</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						<button type="button" class="btn btn-primary" data-dismiss="modal" ng-click="saveAffiliation(tempAffiliation)">Save</button>
					</div>
				</div>
			</div>
		</div>
	
	
	
	
	</div>
})$
