CREATE TABLE persons (
	id       INT PRIMARY KEY AUTO_INCREMENT,
	name     varchar(256) NOT NULL,
	surname  varchar(256) NOT NULL,
	suffix   varchar(256),
	orcid    varchar(256),
	orcid_secure boolean NOT NULL DEFAULT false
);

CREATE TABLE raw_persons (	
	raw_id    varchar(32) PRIMARY KEY,
	name      varchar(256) NOT NULL,
	surname   varchar(256) NOT NULL,
	suffix    varchar(256),
	orcid     varchar(256),
	master_id INT REFERENCES persons(id)
);

CREATE TABLE groups (
	id   varchar(32) PRIMARY KEY,
	name varchar(256) NOT NULL,
	type varchar(32)
);

CREATE TABLE affiliations (
	pid INT REFERENCES persons(id),
	gid varchar(32) REFERENCES groups(id),
	year   int,
	PRIMARY KEY (pid, gid, year),
	FOREIGN KEY (pid) REFERENCES persons(id),
	FOREIGN KEY (gid) REFERENCES groups(id)
);

INSERT INTO groups(id, name, type) VALUES ('UNKNOWN', 'UNKNOWN', 'UNKNOWN');
	
CREATE VIEW affiliations_view AS SELECT 
        concat('dnet:pers:', p.id)                                    AS pid,
        IF (p.orcid_secure = true, p.orcid, NULL)                     AS orcid,
        trim(concat(p.surname,', ',p.name,' ',coalesce(p.suffix,''))) AS pfullname,
        g.id                                                          AS gid,
        g.name                                                        AS gname,
        g.type                                                        AS gtype,
        a.year                                                        AS year 
FROM persons p 
        LEFT JOIN affiliations a ON (p.id = a.pid) 
        LEFT JOIN groups g ON (a.gid = g.id);
