package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;

import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.dedup.kv.DNGFKey;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.isRoot;
import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.rel;

/**
 * Created by sandro on 2/24/17.
 */
public class DedupFixRelationMapper extends TableMapper<DNGFKey, ImmutableBytesWritable> {

    public static final String COUNTER_GROUP = "Fix relations";

    private DedupConfig dedupConf;

    private ImmutableBytesWritable ibw;

    @Override
    protected void setup(final Context context) {
        dedupConf = DedupConfig.load(context.getConfiguration().get(JobParams.DEDUP_CONF));
        System.out.println("dedup Fix Relation mapper\nwf conf: " + dedupConf.toString());

        ibw = new ImmutableBytesWritable();
    }

    @Override
    protected void map(ImmutableBytesWritable key, Result value, Context context) throws IOException, InterruptedException {
        final TypeProtos.Type type = TypeProtos.Type.valueOf(dedupConf.getWf().getEntityType());
        final String rowKey = new String(key.copyBytes());
        final DNGFRowKeyDecoder rowKeyDecoder = DNGFRowKeyDecoder.decode(rowKey);
        if ((!rowKeyDecoder.getType().equals(type)) || !isRoot(rowKey)) {
            return;
        }
        rel(value).values().forEach(dngf -> {
            final String targetId = dngf.getRel().getTarget();
            if (!isRoot(targetId)) {
                if (dngf.getRel().getRelType().getClassid().equals("merges")) {
                    emit(context, DNGFKey.mergesRel(targetId), dngf.toByteArray());
                } else {
                    emit(context, DNGFKey.otherRel(targetId), dngf.toByteArray());
                }
            }
        });
    }

    private void emit(final Context context, final DNGFKey key, final byte[] value) {
        ibw.set(value);
        switch (key.getKeyType().get()) {
        case DNGFKey.MERGES_REL:
            context.getCounter(COUNTER_GROUP, "Merges Relationship").increment(1);
            break;
        case DNGFKey.OTHER_REL:
            context.getCounter(COUNTER_GROUP, "Other Relationship").increment(1);
            break;
        }
        try {
            context.write(key, ibw);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
