/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions2;

import eu.dnetlib.data.actionmanager.actions.AtomicActionDeserialiser;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PromoteActionSetFromHDFSMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private ImmutableBytesWritable keyOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        AtomicAction aa = AtomicActionDeserialiser.fromJSON((String)value.toString());
        byte[] keyOutBytes = Bytes.toBytes((String)aa.getTargetRowKey());
        this.keyOut.set(keyOutBytes);
        Put put = new Put(keyOutBytes);
        put.setWriteToWAL(true);
        put.add(Bytes.toBytes((String)aa.getTargetColumnFamily()), Bytes.toBytes((String)aa.getTargetColumn()), aa.getTargetValue());
        context.write((Object)this.keyOut, (Object)put);
    }
}

