/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.model;

import com.google.gson.annotations.Expose;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Dataset;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Pid;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Publication {
    @Expose
    private String originalId;
    @Expose
    private List<String> titles = new ArrayList<String>();
    @Expose
    private List<String> abstracts = new ArrayList<String>();
    @Expose
    private String language;
    @Expose
    private List<String> subjects = new ArrayList<String>();
    @Expose
    private List<String> creators = new ArrayList<String>();
    @Expose
    private String publicationdate;
    @Expose
    private String publisher;
    @Expose
    private String embargoenddate;
    @Expose
    private List<String> contributor = new ArrayList<String>();
    @Expose
    private List<String> collectedFrom = new ArrayList<String>();
    @Expose
    private List<Pid> pids = new ArrayList<Pid>();
    @Expose
    private List<Publication> publications = new ArrayList<Publication>();
    @Expose
    private List<Dataset> datasets = new ArrayList<Dataset>();

    public static Publication fromDNGF(DNGFProtos.DNGFEntity mainEntity) {
        if (mainEntity.getType() == TypeProtos.Type.dataset) {
            return Publication.generateFromDataset(mainEntity);
        }
        if (mainEntity.getType() == TypeProtos.Type.publication) {
            return Publication.generateFromPublication(mainEntity);
        }
        throw new RuntimeException("Cannot create event for unknown objects");
    }

    private static Publication generateFromDataset(DNGFProtos.DNGFEntity mainEntity) {
        Publication p = new Publication();
        DatasetProtos.Dataset item = mainEntity.getDataset();
        DatasetProtos.Dataset.Metadata metadata = item.getMetadata();
        if (metadata == null) {
            return null;
        }
        p.setTitles(metadata.getTitleList().stream().map(FieldTypeProtos.StructuredProperty::getValue).collect(Collectors.toList()));
        p.setAbstracts(metadata.getDescriptionList().stream().map(FieldTypeProtos.StringField::getValue).collect(Collectors.toList()));
        p.setPids(Collections.singletonList(((List)mainEntity.getExtension(DliProtos.typedIdentifier)).stream().map(pid -> new Pid().setType(pid.getQualifier().getClassid()).setValue(pid.getValue())).filter(Dataset.distinctByKey(pid -> String.format("%s::%s", pid.getType().toLowerCase(), pid.getValue().toLowerCase()))).findFirst().get()));
        p.setOriginalId(p.getPids().get(0).getValue());
        p.setOriginalId(p.getPids().get(0).getValue());
        p.setCreators(metadata.getContributorList().stream().map(FieldTypeProtos.StringField::getValue).distinct().collect(Collectors.toList()));
        p.setCollectedFrom(item.getInstanceList().stream().map(instance -> instance.getHostedby().getValue()).collect(Collectors.toList()));
        p.setPublicationdate(metadata.getDateofacceptance().getValue());
        p.setPublisher(metadata.getPublisher().getValue());
        return p;
    }

    private static Publication generateFromPublication(DNGFProtos.DNGFEntity mainEntity) {
        Publication p = new Publication();
        PublicationProtos.Publication item = mainEntity.getPublication();
        PublicationProtos.Publication.Metadata metadata = item.getMetadata();
        if (metadata == null) {
            return null;
        }
        p.setTitles(metadata.getTitleList().stream().map(FieldTypeProtos.StructuredProperty::getValue).collect(Collectors.toList()));
        p.setAbstracts(metadata.getDescriptionList().stream().map(FieldTypeProtos.StringField::getValue).collect(Collectors.toList()));
        p.setPids(Collections.singletonList(((List)mainEntity.getExtension(DliProtos.typedIdentifier)).stream().map(pid -> new Pid().setType(pid.getQualifier().getClassid()).setValue(pid.getValue())).findFirst().get()));
        p.setOriginalId(p.getPids().get(0).getValue());
        p.setCreators(metadata.getContributorList().stream().map(FieldTypeProtos.StringField::getValue).distinct().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList()));
        p.setCollectedFrom(item.getInstanceList().stream().map(instance -> instance.getHostedby().getValue()).collect(Collectors.toList()));
        p.setPublicationdate(metadata.getDateofacceptance().getValue());
        p.setPublisher(metadata.getPublisher().getValue());
        return p;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Publication setOriginalId(String originalId) {
        this.originalId = originalId;
        return this;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public Publication setTitles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    public List<String> getAbstracts() {
        return this.abstracts;
    }

    public Publication setAbstracts(List<String> abstracts) {
        this.abstracts = abstracts;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Publication setLanguage(String language) {
        this.language = language;
        return this;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public Publication setSubjects(List<String> subjects) {
        this.subjects = subjects;
        return this;
    }

    public List<String> getCreators() {
        return this.creators;
    }

    public Publication setCreators(List<String> creators) {
        this.creators = creators;
        return this;
    }

    public String getPublicationdate() {
        return this.publicationdate;
    }

    public Publication setPublicationdate(String publicationdate) {
        this.publicationdate = publicationdate;
        return this;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Publication setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String getEmbargoenddate() {
        return this.embargoenddate;
    }

    public Publication setEmbargoenddate(String embargoenddate) {
        this.embargoenddate = embargoenddate;
        return this;
    }

    public List<String> getContributor() {
        return this.contributor;
    }

    public Publication setContributor(List<String> contributor) {
        this.contributor = contributor;
        return this;
    }

    public List<String> getCollectedFrom() {
        return this.collectedFrom;
    }

    public Publication setCollectedFrom(List<String> collectedFrom) {
        this.collectedFrom = collectedFrom;
        return this;
    }

    public List<Pid> getPids() {
        return this.pids;
    }

    public Publication setPids(List<Pid> pids) {
        this.pids = pids;
        return this;
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Publication setDatasets(List<Dataset> datasets) {
        this.datasets = datasets;
        return this;
    }

    public List<Publication> getPublications() {
        return this.publications;
    }

    public void setPublications(List<Publication> publications) {
        this.publications = publications;
    }
}

