/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class MergeProvenanceVersionMapper
extends TableMapper<ImmutableBytesWritable, Writable> {
    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap map = (NavigableMap)value.getMap().get(HBaseTableDAO.cfMetadataByte());
        map.keySet().stream().map(Bytes::toString).collect(Collectors.toMap(key -> key, key -> ((NavigableMap)map.get(key.getBytes())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, inner -> HBaseTableDAO.parseProto((byte[])inner.getValue()))))).entrySet().stream().filter(e -> ((Map)e.getValue()).keySet().size() > 1).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            DNGFProtos.DNGF.Builder b = DNGFProtos.DNGF.newBuilder();
            ((Map)e.getValue()).values().forEach(v -> {
                if (v.getEntity().getCollectedfromCount() == 0) {
                    b.mergeFrom(v);
                } else {
                    b.getEntityBuilder().addAllCollectedfrom((Iterable)v.getEntity().getCollectedfromList());
                }
            });
            return b;
        })).entrySet().forEach(dngf -> {
            context.getCounter("merged", ((DNGFProtos.DNGF.Builder)dngf.getValue()).getEntity().getType().toString()).increment(1L);
            this.emit(context, rowkey, (Map.Entry<String, DNGFProtos.DNGF.Builder>)dngf);
        });
    }

    private void emit(Mapper.Context context, ImmutableBytesWritable rowkey, Map.Entry<String, DNGFProtos.DNGF.Builder> entry) {
        try {
            this.outKey.set(rowkey.copyBytes());
            DNGFProtos.DNGF.Builder inputRel = entry.getValue();
            context.write((Object)this.outKey, (Object)HBaseTableDAO.asPut(inputRel.build()));
        }
        catch (Exception e) {
            context.getCounter("Row Skipped", "Error").increment(1L);
        }
    }
}

