/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.mapreduce.hbase.dedup.kv.DNGFKey;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupFixRelationReducer
extends TableReducer<DNGFKey, ImmutableBytesWritable, ImmutableBytesWritable> {
    public static final String COUNTER_GROUP = "Fix relations";
    private DedupConfig dedupConf;
    private Ontologies ontologies;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup fix Relations reducer\n\nwf conf: " + this.dedupConf.toString());
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        System.out.println("ontologies: " + this.ontologies.toJson(true));
    }

    protected void reduce(DNGFKey key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (HBaseTableDAO.isRoot(key.toString())) {
            System.err.println("aborting DedupFixRelationReducer, found root key: " + key);
            context.getCounter(COUNTER_GROUP, "aborted").increment(1L);
            return;
        }
        Iterator<ImmutableBytesWritable> it = values.iterator();
        DNGFProtos.DNGF first = DNGFDecoder.decode((byte[])it.next().copyBytes()).getDNGF();
        if (!first.getRel().getRelType().getClassid().equals("merges")) {
            context.getCounter(COUNTER_GROUP, "Relation skipped").increment(1L);
            return;
        }
        context.getCounter(COUNTER_GROUP, "Item to fix").increment(1L);
        String dedupRoot = first.getRel().getSource();
        it.forEachRemaining(b -> {
            try {
                this.handleRels(context, DNGFDecoder.decode((byte[])b.copyBytes()).getDNGF(), dedupRoot);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void handleRels(Reducer.Context context, DNGFProtos.DNGF dngf, String dedupRoot) throws IOException, InterruptedException {
        String relType = dngf.getRel().getRelType().getClassid();
        if (relType.contains("merges")) {
            return;
        }
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder((FieldTypeProtos.DataInfo)dngf.getDataInfo());
        dataInfoBuilder.setDeletedbyinference(true);
        DNGFProtos.DNGF.Builder dngfBuilder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)dngf);
        dngfBuilder.setDataInfo(dataInfoBuilder.build());
        String sourceKey = dngf.getRel().getSource();
        context.write((Object)new ImmutableBytesWritable(Bytes.toBytes((String)sourceKey)), (Object)HBaseTableDAO.asPut(dngfBuilder.build()));
        context.getCounter(COUNTER_GROUP, "Relation set deleted").increment(1L);
        dngfBuilder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)dngf);
        DNGFProtos.DNGFRel.Builder relBuilder = DNGFProtos.DNGFRel.newBuilder((DNGFProtos.DNGFRel)dngf.getRel());
        relBuilder.setTarget(dedupRoot);
        dngfBuilder.setRel(relBuilder.build());
        context.write((Object)new ImmutableBytesWritable(Bytes.toBytes((String)sourceKey)), (Object)HBaseTableDAO.asPut(dngfBuilder.build()));
        relBuilder = DNGFProtos.DNGFRel.newBuilder((DNGFProtos.DNGFRel)dngf.getRel());
        relBuilder.setTarget(relBuilder.getSource());
        relBuilder.setSource(dedupRoot);
        String inverseRelation = HBaseTableDAO.getInverseRelation(DNGFRelDecoder.decode((DNGFProtos.DNGFRel)dngf.getRel()).getRelDescriptor(), this.ontologies);
        relBuilder.setRelType(FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)relBuilder.getRelType()).setClassid(inverseRelation).setClassname(inverseRelation));
        dngfBuilder.setRel(relBuilder.build());
        context.write((Object)new ImmutableBytesWritable(Bytes.toBytes((String)dedupRoot)), (Object)HBaseTableDAO.asPut(dngfBuilder.build()));
        context.getCounter(COUNTER_GROUP, "Relation fixed").increment(2L);
    }

    private Iterable<DNGFProtos.DNGF> toDNGF(Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, ibw -> DNGFDecoder.decode((byte[])ibw.copyBytes()).getDNGF());
    }
}

