/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupMarkDeletedEntityMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private static final Log log = LogFactory.getLog(DedupMarkDeletedEntityMapper.class);
    private static final String DEFAULT_PROVENANCE = "dnet";
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString()));
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        List<String> mergedIn = HBaseTableDAO.getTargetIds(value, "isMergedIn");
        if (mergedIn != null && !mergedIn.isEmpty()) {
            byte[] row = rowkey.copyBytes();
            this.emitBody(context, row, HBaseTableDAO.getMetadata(value, type));
        } else {
            context.getCounter(type.toString(), "row not merged").increment(1L);
        }
    }

    private void emitBody(Mapper.Context context, byte[] row, DNGFProtos.DNGF prototype) throws IOException, InterruptedException {
        String type = this.dedupConf.getWf().getEntityType();
        if (prototype == null) {
            context.getCounter(type, "missing body").increment(1L);
            System.err.println("missing body: " + new String(row));
            return;
        }
        if (prototype.getDataInfo().getDeletedbyinference()) {
            context.getCounter(type, "bodies already deleted").increment(1L);
        } else {
            DNGFProtos.DNGF.Builder oafRoot = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)prototype);
            oafRoot.getDataInfoBuilder().setDeletedbyinference(true).setInferred(true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId());
            if (!oafRoot.getDataInfoBuilder().hasProvenanceaction()) {
                context.getCounter(type, "missing provenance, setting dnet").increment(1L);
                oafRoot.getDataInfoBuilder().setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassname(DEFAULT_PROVENANCE).setClassid(DEFAULT_PROVENANCE).setSchemename(DEFAULT_PROVENANCE).setSchemeid(DEFAULT_PROVENANCE));
            }
            context.write((Object)new ImmutableBytesWritable(row), (Object)HBaseTableDAO.asPut(oafRoot.build()));
            context.getCounter(type, "bodies marked deleted").increment(1L);
        }
    }
}

