/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupMergeRelationVersionMapper
extends TableMapper<ImmutableBytesWritable, Writable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();
    private Ontologies ontologies;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        System.out.println("ontologies: " + this.ontologies.toJson(true));
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (!HBaseTableDAO.isRoot(rowkey)) {
            context.getCounter("skipped row", "total").increment(1L);
            return;
        }
        HBaseTableDAO.relVersions(value, "isMergedIn", "merges", "isSimilarTo").entrySet().stream().filter(e -> ((Map)e.getValue()).keySet().size() > 1).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            DNGFProtos.DNGF.Builder b = DNGFProtos.DNGF.newBuilder();
            ((Map)e.getValue()).values().forEach(v -> {
                b.mergeFrom(v);
                String relType = RelDescriptor.asString((FieldTypeProtos.Qualifier)v.getRel().getRelType());
                context.getCounter("merged", relType).increment(1L);
            });
            return b;
        })).entrySet().forEach(dngf -> this.emit(context, rowkey, (Map.Entry<String, DNGFProtos.DNGF.Builder>)dngf));
    }

    private void emit(Mapper.Context context, ImmutableBytesWritable rowkey, Map.Entry<String, DNGFProtos.DNGF.Builder> entry) {
        try {
            this.outKey.set(rowkey.copyBytes());
            DNGFProtos.DNGF.Builder inputRel = entry.getValue();
            System.out.println(String.format("wirting row: %s, data: %s", new String(rowkey.copyBytes()), inputRel.toString()));
            context.write((Object)this.outKey, (Object)HBaseTableDAO.asPut(inputRel.build()));
            String target = inputRel.getRel().getTarget();
            TypeProtos.Type targetType = inputRel.getRel().getTargetType();
            TypeProtos.Type sourceType = inputRel.getRel().getSourceType();
            DNGFProtos.DNGFRel.Builder relBuilder = DNGFProtos.DNGFRel.newBuilder((DNGFProtos.DNGFRel)inputRel.getRel());
            relBuilder.setTargetType(sourceType);
            relBuilder.setSourceType(targetType);
            relBuilder.setTarget(relBuilder.getSource());
            relBuilder.setSource(target);
            String inverseRelation = HBaseTableDAO.getInverseRelation(inputRel, this.ontologies);
            relBuilder.setRelType(FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)relBuilder.getRelType()).setClassname(inverseRelation).setClassid(inverseRelation).build());
            this.outKey.set(relBuilder.getSource().getBytes());
            inputRel.setRel(relBuilder.build());
            context.write((Object)this.outKey, (Object)HBaseTableDAO.asPut(inputRel.build()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

