/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class SimpleDedupPersonReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final int MAX_Q_SIZE = 3000;
    private DedupConfig dedupConf;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            Queue<DNGFDecoder> q = this.prepare(key, values, context);
            if (q.size() > 1) {
                if (q.size() < 20) {
                    context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", this.lpad(q.size())).increment(1L);
                } else {
                    context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", "> 20").increment(1L);
                }
                String min = q.stream().map(HBaseTableDAO.idDecoder()).min(String::compareTo).get();
                if (min == null) {
                    context.getCounter(this.dedupConf.getWf().getEntityType(), "unable to find min").increment(1L);
                    return;
                }
                String rootId = HBaseTableDAO.newId(min, this.dedupConf.getWf().getDedupRun());
                while (!q.isEmpty()) {
                    this.markDuplicate(context, rootId, q.remove());
                }
            } else {
                context.getCounter(this.dedupConf.getWf().getEntityType(), "1").increment(1L);
            }
        }
        catch (Throwable e) {
            System.out.println("GOT EX " + e);
            e.printStackTrace(System.err);
            context.getCounter(this.dedupConf.getWf().getEntityType(), e.getClass().toString()).increment(1L);
        }
    }

    private Queue<DNGFDecoder> prepare(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) {
        LinkedList q = Lists.newLinkedList();
        for (DNGFDecoder decoder : Iterables.transform(values, (Function)new Function<ImmutableBytesWritable, DNGFDecoder>(){

            public DNGFDecoder apply(ImmutableBytesWritable ibw) {
                return DNGFDecoder.decode((byte[])ibw.copyBytes());
            }
        })) {
            q.add(decoder);
            if (q.size() < 3000) continue;
            context.getCounter("[" + key.toString() + "]", "size > 3000").increment(1L);
            break;
        }
        return q;
    }

    private void markDuplicate(Reducer.Context context, String rootId, DNGFDecoder decoder) throws IOException, InterruptedException {
        DNGFProtos.DNGF.Builder builder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)decoder.getDNGF());
        builder.getDataInfoBuilder().setDeletedbyinference(true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId());
        DNGFProtos.DNGF oaf = builder.build();
        String oafId = oaf.getEntity().getId();
        String entityName = this.dedupConf.getWf().getEntityType();
        this.emit(context, Bytes.toBytes((String)oafId), HBaseTableDAO.cfMetadata(), Bytes.toBytes((String)entityName), oaf.toByteArray());
        context.getCounter(entityName, "marked as deleted").increment(1L);
        TypeProtos.Type entityType = TypeProtos.Type.valueOf((String)entityName);
        byte[] rowkey = Bytes.toBytes((String)rootId);
        byte[] merges = HBaseTableDAO.getDedupQualifier_mergesBytes(entityType, oafId);
        this.emit(context, rowkey, HBaseTableDAO.cfRels(), merges, this.buildRel(rowkey, Bytes.toBytes((String)oafId), "merges"));
        byte[] mergedIn = HBaseTableDAO.getDedupQualifier_mergedInBytes(entityType, new String(rowkey));
        this.emit(context, Bytes.toBytes((String)oafId), HBaseTableDAO.cfRels(), mergedIn, this.buildRel(Bytes.toBytes((String)oafId), rowkey, "isMergedIn"));
        context.getCounter(entityName, new String(merges)).increment(1L);
        context.getCounter(entityName, new String(mergedIn)).increment(1L);
    }

    private void emit(Reducer.Context context, byte[] rowkey, String family, byte[] qualifier, byte[] value) throws IOException, InterruptedException {
        Put put = new Put(DNGFRowKeyDecoder.decode((byte[])rowkey).getKey().getBytes());
        put.setWriteToWAL(true);
        put.add(Bytes.toBytes((String)family), qualifier, value);
        context.write((Object)new ImmutableBytesWritable(rowkey), (Object)put);
    }

    private byte[] buildRel(byte[] from, byte[] to, String relClass) {
        DNGFProtos.DNGFRel.Builder oafRel = HBaseTableDAO.getDedup(new String(from), new String(to), relClass);
        DNGFProtos.DNGF oaf = DNGFProtos.DNGF.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetXsltFunctions.getDataInfo(null, (String)"", (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId())).setRel(oafRel).build();
        return oaf.toByteArray();
    }

    private String lpad(int s) {
        return StringUtils.leftPad((String)String.valueOf(s), (int)String.valueOf(3000).length());
    }
}

