/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import eu.dnetlib.data.mapreduce.hbase.dedup.cc.VertexWritable;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class HBaseToSimilarityGraphMapper
extends TableMapper<Text, VertexWritable> {
    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        VertexWritable vertex = new VertexWritable();
        Text realKey = new Text(keyIn.copyBytes());
        vertex.checkAndSetMinimalVertex(realKey);
        vertex.addVertex(realKey);
        for (KeyValue kv : value.list()) {
            String qualifier = new String(kv.getQualifier());
            String targetId = StringUtils.substringAfter((String)qualifier, (String)":");
            Text tmp = new Text(targetId);
            vertex.checkAndSetMinimalVertex(tmp);
            vertex.addVertex(tmp);
        }
        context.write((Object)realKey, (Object)vertex);
        for (Text edge : vertex.getEdges()) {
            context.write((Object)edge, (Object)vertex.makeMessage());
        }
    }
}

