/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dli;

import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.dli.proto.DNGFDLISummaryConverter;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareSummaryDataMapper
extends TableMapper<Text, Text> {
    private static final String SCHOLIX = "Scholix";
    private Ontologies ontologies = null;
    private Text outKey;
    private Text outValue;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        this.outKey = new Text();
        this.outValue = new Text();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        DNGFRowKeyDecoder keyDecoder = DNGFRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        TypeProtos.Type type = keyDecoder.getType();
        DNGFProtos.DNGF entity = HBaseTableDAO.getMetadata(value, type);
        if (this.isValid(entity)) {
            if (!this.deletedByInference(entity)) {
                DNGFDLISummaryConverter converter = new DNGFDLISummaryConverter();
                converter.setMainDNGFEntity(entity);
                this.incrementCounter(context, KindProtos.Kind.entity.toString(), type.toString(), 1);
                HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").forEach((qualifier, r) -> {
                    if (!r.getDataInfo().getDeletedbyinference()) {
                        converter.addRelation(r);
                    }
                });
                if (converter.isValid()) {
                    this.emit(new String(keyIn.copyBytes()), context, converter.convertAsJson());
                }
            } else {
                this.incrementCounter(context, SCHOLIX, "Deletedbyinference: " + type.toString(), 1);
            }
        } else {
            this.incrementCounter(context, SCHOLIX, "Missing body: " + type.toString(), 1);
        }
    }

    private boolean isValid(DNGFProtos.DNGF entity) {
        return entity != null && entity.isInitialized();
    }

    private boolean deletedByInference(DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private void emit(String key, Mapper.Context context, String data) {
        if (data == null) {
            return;
        }
        this.outKey.set(key);
        this.outValue.set(data.getBytes());
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

