/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.wds;

import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class ExtendProjectInfoReducer
extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable, Put> {
    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();
    private ImmutableBytesWritable outValue = new ImmutableBytesWritable();

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ArrayList projects = new ArrayList();
        DNGFProtos.DNGFEntity.Builder dataset = DNGFProtos.DNGFEntity.newBuilder();
        values.forEach(it -> {
            DNGFProtos.DNGFEntity entity = this.tryToParseEntity((ImmutableBytesWritable)it);
            if (entity != null) {
                dataset.mergeFrom(entity);
            } else {
                FieldTypeProtos.ProjectRelation p = this.tryToParseProject((ImmutableBytesWritable)it);
                if (p != null) {
                    projects.add(p);
                }
            }
        });
        if (dataset.hasDataset() && projects.size() > 0) {
            projects.forEach(p -> {
                DatasetProtos.Dataset.Metadata.Builder cfr_ignored_0 = (DatasetProtos.Dataset.Metadata.Builder)dataset.getDatasetBuilder().getMetadataBuilder().addExtension(WdsDatasetProtos.WdsDataset.projects, p);
            });
            context.getCounter("PropagatedProjects", "for Dataset").increment((long)projects.size());
            this.outKey.set(key.copyBytes());
            this.outValue.set(dataset.build().toByteArray());
            context.write((Object)this.outKey, (Object)HBaseTableDAO.asPutByCollectedFrom(DNGFProtos.DNGF.newBuilder().setKind(KindProtos.Kind.entity).setEntity(dataset.build()).build()));
        }
    }

    private DNGFProtos.DNGFEntity tryToParseEntity(ImmutableBytesWritable input) {
        try {
            DNGFProtos.DNGFEntity dngfEntity = DNGFProtos.DNGFEntity.parseFrom((byte[])input.copyBytes());
            return dngfEntity;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private FieldTypeProtos.ProjectRelation tryToParseProject(ImmutableBytesWritable input) {
        try {
            FieldTypeProtos.ProjectRelation project = FieldTypeProtos.ProjectRelation.parseFrom((byte[])input.copyBytes());
            return project;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

