package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.dli.DLIObjectProtos;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.asPut;


/**
 * Created by sandro on 5/2/17.
 */
public class MergeProvenanceVersionMapper extends TableMapper<ImmutableBytesWritable, Writable> {

    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {

    }

    @Override
    protected void map(final ImmutableBytesWritable rowkey, final Result value, final Context context) throws IOException, InterruptedException {
        final NavigableMap<byte[], NavigableMap<Long, byte[]>> map = value.getMap().get(HBaseTableDAO.cfMetadataByte());
        map.keySet().stream()
                .map(Bytes::toString)
                .collect(Collectors.toMap(
                        key -> key,
                        key -> map.get(key.getBytes()).entrySet()
                                .stream()
                                .collect(Collectors.toMap(
                                        Map.Entry::getKey,
                                        inner -> HBaseTableDAO.parseProto(inner.getValue()))
                                ))).entrySet().stream()
                .filter(e -> e.getValue().keySet().size() > 1).collect(Collectors.toMap(
                Map.Entry::getKey,
                e -> {
                    final DNGFProtos.DNGF.Builder b = DNGFProtos.DNGF.newBuilder();
                    e.getValue().values().forEach(v -> {
                        if (v.getEntity().getCollectedfromCount() == 0)
                            b.mergeFrom(v);
                        else {
                            b.getEntityBuilder().addAllCollectedfrom(v.getEntity().getCollectedfromList());
                        }
                    });
                    return b;
                }
        )).entrySet().forEach(dngf -> {
            context.getCounter("merged", dngf.getValue().getEntity().getType().toString()).increment(1);
            emit(context, rowkey, dngf);
        });
    }

    private void emit(final Context context, final ImmutableBytesWritable rowkey, final Map.Entry<String, DNGFProtos.DNGF.Builder> entry) {
        try {
            outKey.set(rowkey.copyBytes());
            DNGFProtos.DNGF.Builder inputRel = entry.getValue();
            context.write(outKey, asPut(inputRel.build()));
        } catch (Exception e) {
            context.getCounter("Row Skipped", "Error").increment(1);
        }


    }
}
