package eu.dnetlib.data.mapreduce.hbase.dli.kv;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Partitioner;

/**
 * Created by claudio on 13/03/2017.
 */
public class NaturalKeyPartitioner extends Partitioner<DliKey, ImmutableBytesWritable > {

	@Override
	public int getPartition(DliKey key, ImmutableBytesWritable  val, int numPartitions) {
		final int res = Math.abs(key.getId().hashCode() % numPartitions);

		//System.out.println(String.format("%s goes to partition %s", key.toString(), res));

		return res;
	}

}
