/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.broker.model.ESEvent;
import eu.dnetlib.data.mapreduce.hbase.broker.model.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Pid;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Publication;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DatasetRelationEnrichmentReducer
extends Reducer<DliKey, Text, Text, Text> {
    private Text outValue;
    private Text outKey;
    private Gson gson;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.outValue = new Text();
        this.outKey = new Text();
        this.gson = new Gson();
    }

    protected void reduce(DliKey key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Publication targetPublication;
        Iterator<Text> v_iter = values.iterator();
        Text first = v_iter.next();
        try {
            targetPublication = (Publication)this.gson.fromJson(first.toString(), Publication.class);
        }
        catch (Throwable e) {
            context.getCounter("Broker Enrichment", "Error first element unexpected: ").increment(1L);
            return;
        }
        if (!this.isValidTarget(targetPublication)) {
            context.getCounter("Broker Enrichment", "Error first element missing target ").increment(1L);
            return;
        }
        if (!v_iter.hasNext()) {
            context.getCounter("Broker Enrichment", "NOOP").increment(1L);
            return;
        }
        HashMap<String, ESEvent> events = new HashMap<String, ESEvent>();
        while (v_iter.hasNext()) {
            String eventIdentifier;
            ESEvent currentEvent = (ESEvent)this.gson.fromJson(v_iter.next().toString(), ESEvent.class);
            OpenAireEventPayload currentPayload = (OpenAireEventPayload)this.gson.fromJson(currentEvent.getPayload(), OpenAireEventPayload.class);
            currentEvent.getMap().setTarget_publication_title(currentPayload.getPublication().getTitles().get(0));
            if (targetPublication.getDatasets() != null && targetPublication.getDatasets().size() > 0) {
                eventIdentifier = this.generateEventIdentifier(currentPayload.getPublication().getPids().get(0), targetPublication.getDatasets().get(0).getPids().get(0), currentEvent.getTopic());
                currentPayload.getPublication().setDatasets(targetPublication.getDatasets());
            } else {
                eventIdentifier = this.generateEventIdentifier(currentPayload.getPublication().getPids().get(0), targetPublication.getPublications().get(0).getPids().get(0), currentEvent.getTopic());
                currentPayload.getPublication().setPublications(targetPublication.getPublications());
            }
            currentEvent.setEventId(eventIdentifier);
            currentPayload.setHighlight(targetPublication);
            currentEvent.setPayload(this.gson.toJson((Object)currentPayload));
            events.put(currentEvent.getEventId(), currentEvent);
        }
        events.values().forEach(r -> {
            this.emit(context, this.gson.toJson(r));
            context.getCounter("Broker Enrichment Event", "Generated Event").increment(1L);
        });
    }

    private String generateEventIdentifier(Pid source, Pid target, String topic) {
        return this.calculateEventId(topic, String.format("%s:%s", source.getType(), source.getValue()), String.format("%s:%s", target.getType(), target.getValue()));
    }

    private String calculateEventId(String topic, String sourceId, String targetId) {
        return "event-" + DigestUtils.md5Hex((String)topic).substring(0, 6) + "-" + DigestUtils.md5Hex((String)sourceId).substring(0, 8) + "-" + DigestUtils.md5Hex((String)targetId).substring(0, 8);
    }

    private boolean isValidTarget(Publication p) {
        return p.getPublications() != null && p.getPublications().size() > 0 || p.getDatasets() != null && p.getDatasets().size() > 0;
    }

    private void emit(Reducer.Context context, String data) {
        this.outValue.set(data.getBytes());
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

