/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class SequenceFileRecordMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private String family;
    private String qualifier;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.family = context.getConfiguration().get("hbase.target.family").trim();
        this.qualifier = context.getConfiguration().get("hbase.target.qualifier").trim();
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] rowKey = Bytes.toBytes((String)key.toString());
        Put put = new Put(rowKey).add(Bytes.toBytes((String)this.family), Bytes.toBytes((String)this.qualifier), Bytes.toBytes((String)value.toString()));
        context.write((Object)new ImmutableBytesWritable(rowKey), (Object)put);
    }
}

