/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.hbase.dedup.kv.DNGFKey;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFixRelationMapper
extends TableMapper<DNGFKey, ImmutableBytesWritable> {
    public static final String COUNTER_GROUP = "Fix relations";
    private DedupConfig dedupConf;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup Fix Relation mapper\nwf conf: " + this.dedupConf.toString());
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        String rowKey = new String(key.copyBytes());
        DNGFRowKeyDecoder rowKeyDecoder = DNGFRowKeyDecoder.decode((String)rowKey);
        if (!rowKeyDecoder.getType().equals((Object)type) || !HBaseTableDAO.isRoot(rowKey)) {
            return;
        }
        HBaseTableDAO.rel(value, new String[0]).values().forEach(dngf -> {
            String targetId = dngf.getRel().getTarget();
            if (!HBaseTableDAO.isRoot(targetId)) {
                if (dngf.getRel().getRelType().getClassid().equals("merges")) {
                    this.emit(context, DNGFKey.mergesRel(targetId), dngf.toByteArray());
                } else {
                    this.emit(context, DNGFKey.otherRel(targetId), dngf.toByteArray());
                }
            }
        });
    }

    private void emit(Mapper.Context context, DNGFKey key, byte[] value) {
        this.ibw.set(value);
        switch (key.getKeyType().get()) {
            case 0: {
                context.getCounter(COUNTER_GROUP, "Merges Relationship").increment(1L);
                break;
            }
            case 1: {
                context.getCounter(COUNTER_GROUP, "Other Relationship").increment(1L);
            }
        }
        try {
            context.write((Object)key, (Object)this.ibw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

