/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.Person;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class SimpleDedupPersonMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private Text rowKey;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        this.rowKey = new Text();
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (HBaseTableDAO.isRoot(new String(keyIn.copyBytes()))) {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "roots skipped").increment(1L);
            return;
        }
        byte[] body = result.getValue(this.dedupConf.getWf().getEntityType().getBytes(), HBaseTableDAO.cfMetadataByte());
        if (body != null) {
            try {
                DNGFDecoder decoder = DNGFDecoder.decode((byte[])body);
                String hash = new Person(decoder.getEntity().getPerson().getMetadata().getFullname().getValue(), false).hash();
                this.rowKey.set(hash);
                this.ibw.set(body);
                context.write((Object)this.rowKey, (Object)this.ibw);
            }
            catch (Throwable e) {
                System.out.println("GOT EX " + e);
                e.printStackTrace(System.err);
                context.getCounter(this.dedupConf.getWf().getEntityType(), e.getClass().toString()).increment(1L);
            }
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "missing body").increment(1L);
        }
    }
}

