/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.dedup.cc.VertexWritable;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class ConnectedComponentsReducer
extends TableReducer<Text, VertexWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(ConnectedComponentsReducer.class);
    private DedupConfig dedupConf;
    private TypeProtos.Type type;

    protected void setup(Reducer.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString()));
        this.type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
    }

    protected void reduce(Text key, Iterable<VertexWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        HashSet set = Sets.newHashSet();
        for (VertexWritable v : values) {
            for (Text t : v.getEdges()) {
                set.add(t.toString());
            }
        }
        String rootId = HBaseTableDAO.newId(key.toString(), this.dedupConf.getWf().getDedupRun());
        for (String targetId : set) {
            context.write((Object)HBaseTableDAO.ibw(targetId), (Object)HBaseTableDAO.asPut(this.buildRel(targetId, rootId, HBaseTableDAO.getDedupQualifier_mergedIn(this.type, rootId))));
            context.write((Object)HBaseTableDAO.ibw(rootId), (Object)HBaseTableDAO.asPut(this.buildRel(rootId, targetId, HBaseTableDAO.getDedupQualifier_merges(this.type, targetId))));
            context.getCounter(this.dedupConf.getWf().getEntityType(), "dedupRel (x2)").increment(1L);
        }
    }

    private DNGFProtos.DNGF buildRel(String from, String to, String semantics) {
        DNGFProtos.DNGFRel.Builder oafRel = HBaseTableDAO.getDedup(from, to, semantics);
        DNGFProtos.DNGF dngf = DNGFProtos.DNGF.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetXsltFunctions.getDataInfo(null, (String)"", (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId())).setRel(oafRel).build();
        return dngf;
    }
}

