/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.wds;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WDSIndexItemProtos;
import eu.dnetlib.wds.proto.DNGFWDSIndexConverter;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class IndexWDSMapper
extends TableMapper<Text, Text> {
    private Text outKey;
    private Text outValue;
    private static String WDS_COUNTER = "WDS_INDEX";

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.outKey = new Text();
        this.outValue = new Text();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        DNGFWDSIndexConverter converter = new DNGFWDSIndexConverter();
        DNGFRowKeyDecoder keyDecoder = DNGFRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        TypeProtos.Type type = keyDecoder.getType();
        DNGFProtos.DNGF entity = HBaseTableDAO.getMetadata(value, type);
        if (this.isValid(entity) && !this.deletedByInference(entity)) {
            WDSIndexItemProtos.Item.Builder item = converter.convert(entity);
            HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(r -> {
                if (!this.deletedByInference((DNGFProtos.DNGF)r)) {
                    converter.addRelation(item, r.getRel());
                }
            });
            this.emit(new String(keyIn.copyBytes()), context, JsonFormat.printToString((Message)item.build()));
        }
    }

    private boolean isValid(DNGFProtos.DNGF entity) {
        return entity != null && entity.isInitialized();
    }

    private boolean deletedByInference(DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private void emit(String key, Mapper.Context context, String data) {
        if (data == null) {
            return;
        }
        this.outKey.set(key);
        this.outValue.set(data.getBytes());
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

