/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.LicenseComparator;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.Ontology;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRecordFactory {
    protected final Ontologies ontologies;
    protected final Map<String, Integer> relCounters = Maps.newHashMap();
    protected Set<String> specialDatasourceTypes = Sets.newHashSet((Object[])new String[]{"scholarcomminfra", "infospace", "pubsrepository::mock", "entityregistry"});
    protected DNGFDecoder mainEntity = null;
    protected String key = null;
    protected List<DNGFDecoder> relations = Lists.newLinkedList();
    protected List<DNGFDecoder> children = Lists.newLinkedList();
    protected EntityConfigTable entityConfigTable;
    protected ContextMapper contextMapper;
    protected Map<String, Integer> counters = Maps.newHashMap();
    protected boolean entityDefaults;
    protected boolean relDefaults;
    protected boolean childDefaults;
    protected Set<String> contextes = Sets.newHashSet();

    public AbstractRecordFactory(EntityConfigTable entityConfigTable, ContextMapper contextMapper, Ontologies ontologies, boolean entityDefaults, boolean relDefaults, boolean childDefaults) {
        this.entityConfigTable = entityConfigTable;
        this.contextMapper = contextMapper;
        this.entityDefaults = entityDefaults;
        this.relDefaults = relDefaults;
        this.childDefaults = childDefaults;
        this.ontologies = ontologies;
    }

    public static String removePrefix(String s) {
        if (s.contains("|")) {
            return StringUtils.substringAfter((String)s, (String)"|");
        }
        return s;
    }

    public Map<String, Integer> getRelCounters() {
        return this.relCounters;
    }

    public void setMainEntity(DNGFDecoder mainEntity) {
        this.mainEntity = mainEntity;
        this.key = mainEntity.decodeEntity().getId();
    }

    public void addRelation(TypeProtos.Type type, DNGFDecoder rel) {
        this.addRelOrChild(type, this.relations, rel);
    }

    public void addChild(TypeProtos.Type type, DNGFDecoder child) {
        this.addRelOrChild(type, this.children, child);
    }

    private void addRelOrChild(TypeProtos.Type type, List<DNGFDecoder> list, DNGFDecoder decoder) {
        DNGFProtos.DNGFRel oafRel = decoder.getDNGFRel();
        String relFamily = oafRel.getRelType().getSchemeid();
        String relType = oafRel.getRelType().getClassid();
        String relInverse = ((Ontology)this.ontologies.get((Object)relFamily)).inverseOf(relType);
        String rd = relFamily + "_" + relInverse;
        LinkDescriptor ld = this.entityConfigTable.getDescriptor(type, new RelDescriptor(rd));
        this.getRelCounters().putIfAbsent(rd, 0);
        if (ld == null) {
            list.add(decoder);
            return;
        }
        if (ld.getMax() < 0) {
            list.add(decoder);
            return;
        }
        if (this.getRelCounters().get(rd) < ld.getMax()) {
            this.getRelCounters().put(rd, this.getRelCounters().get(rd) + 1);
            list.add(decoder);
        }
    }

    protected Set<Map.Entry<Descriptors.FieldDescriptor, Object>> filterFields(GeneratedMessage fields, Set<String> filter) {
        if (filter != null && filter.size() > 0) {
            Predicate p = descriptor -> {
                if (fields == null) {
                    return false;
                }
                String name = descriptor.getName();
                return filter.contains(name);
            };
            Map filtered = Maps.filterKeys((Map)fields.getAllFields(), (Predicate)p);
            return filtered.entrySet();
        }
        return fields.getAllFields().entrySet();
    }

    public String getId() {
        return this.key;
    }

    public boolean isValid() {
        return this.mainEntity != null;
    }

    public FieldTypeProtos.Qualifier getQualifier(String classid, String classname, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemename).setSchemename(schemename).build();
    }

    protected Object getDefault(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                return false;
            }
            case BYTES: {
                return "".getBytes();
            }
            case MESSAGE: {
                if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                    return this.defaultQualifier();
                }
                if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StructuredProperty.newBuilder().setValue("").setQualifier(this.defaultQualifier()).build();
                }
                if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.KeyValue.newBuilder().setKey("").setValue("").build();
                }
                if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StringField.newBuilder().setValue("").build();
                }
                if (FieldTypeProtos.BoolField.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.BoolField.newBuilder().buildPartial();
                }
                return null;
            }
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FIXED32: 
            case FIXED64: 
            case FLOAT: {
                return 0;
            }
            case STRING: {
                return "";
            }
        }
        return null;
    }

    private FieldTypeProtos.Qualifier defaultQualifier() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename("").build();
    }

    protected void incrementCounter(String type) {
        if (!this.counters.containsKey(type)) {
            this.counters.put(type, 1);
        } else {
            this.counters.put(type, this.counters.get(type) + 1);
        }
    }

    protected FieldTypeProtos.Qualifier getBestLicense() {
        FieldTypeProtos.Qualifier bestLicense = this.getQualifier("UNKNOWN", "not available", "dnet:access_modes");
        LicenseComparator lc = new LicenseComparator();
        for (FieldTypeProtos.Instance instance : ((PublicationProtos.Publication)this.mainEntity.decodeEntity().getEntity()).getInstanceList()) {
            if (lc.compare(bestLicense, instance.getLicence()) <= 0) continue;
            bestLicense = instance.getLicence();
        }
        return bestLicense;
    }

    protected void manageInferred(String rd, FieldTypeProtos.DataInfo info) {
        if (info.getInferred()) {
            this.incrementCounter(rd + "_inferred");
        } else if (StringUtils.startsWith((CharSequence)info.getProvenanceaction().getClassid(), (CharSequence)"sysimport:crosswalk")) {
            this.incrementCounter(rd + "_collected");
        } else if (StringUtils.startsWith((CharSequence)info.getProvenanceaction().getClassid(), (CharSequence)"user:")) {
            this.incrementCounter(rd + "_claimed");
        }
    }

    public abstract String build();
}

