package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import java.io.IOException;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;

import static eu.dnetlib.data.graph.utils.RelDescriptor.QUALIFIER_SEPARATOR;

/**
 * Created by claudio on 14/10/15.
 */
public class HBaseToSimilarityGraphMapper extends TableMapper<Text, VertexWritable> {

	@Override
	protected void map(final ImmutableBytesWritable keyIn, final Result value, final Context context) throws IOException, InterruptedException {

		final VertexWritable vertex = new VertexWritable();
		final Text realKey = new Text(keyIn.copyBytes());

		vertex.checkAndSetMinimalVertex(realKey);
		vertex.addVertex(realKey);

		for (KeyValue kv : value.list()) {

			final String qualifier = new String(kv.getQualifier());
			final String targetId = StringUtils.substringAfter(qualifier, QUALIFIER_SEPARATOR);

			//System.out.println(String.format("qualifier: '%s' targetId: '%s'", qualifier, targetId));

			Text tmp = new Text(targetId);
			vertex.checkAndSetMinimalVertex(tmp);
			vertex.addVertex(tmp);
		}

		context.write(realKey, vertex);

		for (Text edge : vertex.getEdges()) {
			context.write(edge, vertex.makeMessage());
		}
	}

}
