/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.transform.DNGFEntityMerger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class UpdateMerger {
    private static final String UPDATE_MERGER = "UPDATE_MERGE";
    private static final String N_MERGES = "N_MERGES";

    public static DNGFProtos.DNGF mergeBodyUpdates(Mapper.Context context, Map<byte[], byte[]> map, TypeProtos.Type type) throws InvalidProtocolBufferException {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<byte[], byte[]> e : map.entrySet()) {
            stringMap.put(Bytes.toString((byte[])e.getKey()), e.getValue());
        }
        return UpdateMerger.doMerge(context, stringMap, type);
    }

    public static DNGFProtos.DNGF mergeBodyUpdates(Map<String, byte[]> map, TypeProtos.Type type) throws InvalidProtocolBufferException {
        return UpdateMerger.doMerge(null, map, type);
    }

    private static DNGFProtos.DNGF doMerge(Mapper.Context context, Map<String, byte[]> map, TypeProtos.Type type) throws InvalidProtocolBufferException {
        byte[] value = map.get(type.toString());
        if (value == null) {
            return null;
        }
        DNGFProtos.DNGF.Builder builder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)DNGFDecoder.decode((byte[])value, (GeneratedMessage.GeneratedExtension[])new GeneratedMessage.GeneratedExtension[]{WdsDatasetProtos.WdsDataset.geolocation}).getDNGF());
        ArrayList keys = Lists.newArrayList();
        for (String o : map.keySet()) {
            if (!o.startsWith("update_")) continue;
            keys.add(o);
        }
        if (!keys.isEmpty()) {
            Collections.sort(keys);
            for (String k : keys) {
                DNGFProtos.DNGF update = DNGFProtos.DNGF.parseFrom((byte[])map.get(k));
                builder.mergeFrom(update);
            }
            builder = DNGFEntityMerger.merge((DNGFProtos.DNGF.Builder)builder);
            if (context != null) {
                context.getCounter(UPDATE_MERGER, N_MERGES).increment((long)keys.size());
            }
        }
        return builder.build();
    }
}

