package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

public class RelClasses {

	private final Map<String, String> map = Maps.newHashMap();

	private final Type typeToken = new TypeToken<List<String>>() {}.getType();

	public static RelClasses fromJSon(String json) {
		return new RelClasses(json);
	}

	public RelClasses(String json) {
		List<String> list = new Gson().fromJson(json, typeToken);
		for (String s : list) {
			String[] split = s.split(":");
			map.put(split[0], split[1]);
		}
	}

	public String getInverse(String relClass) {
		return map.get(relClass);
	}

	@Override
	public String toString() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(map);
	}

}
