/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;

public class DedupRootsToCsvReducer
extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(DedupRootsToCsvReducer.class);
    private static final String COUNTER_GROUP = "csv";
    private DedupConfig dedupConf;
    private String DELIM;
    private String WRAP;
    private Text tKey;
    private Text tValue;
    private MultipleOutputs<Text, Text> mos;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.tKey = new Text();
        this.tValue = new Text();
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("wf conf: " + this.dedupConf.toString()));
        this.DELIM = context.getConfiguration().get("mapred.textoutputformat.separator", "!");
        this.WRAP = context.getConfiguration().get("mapred.textoutputformat.wrapper", "#");
        log.info((Object)("using field DELIMITER: '" + this.DELIM + "'"));
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        String csv = Joiner.on((String)this.DELIM).join(Iterables.transform(values, ibw -> new String(ibw.copyBytes(), Charset.forName("UTF-8"))));
        this.tKey.set(StringUtils.substringBefore((String)csv, (String)this.DELIM));
        this.tValue.set(StringUtils.substringAfter((String)csv, (String)this.DELIM));
        this.mos.write(Tables.Groups.toString(), (Object)this.tKey, (Object)this.tValue, Tables.Groups.toString());
        context.getCounter(COUNTER_GROUP, "groups").increment((long)StringUtils.countMatches((CharSequence)csv, (CharSequence)this.DELIM));
    }

    public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.mos.close();
    }

    static enum Tables {
        Groups,
        NativeGroups,
        NativeEntities;

    }
}

