/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dli;

import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.dli.proto.ScholixConverter;
import eu.dnetlib.dli.proto.ScholixVersion;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareScholixDataMapper
extends TableMapper<DliKey, ImmutableBytesWritable> {
    private static final String SCHOLIX = "Scholix";
    private static final String DNGF = "DNGF";
    private String scholixVersion;
    private Ontologies ontologies;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        this.scholixVersion = context.getConfiguration().get("ScholixVersion");
        System.out.println("ontologies: " + this.ontologies.toJson(true));
        System.out.println("scholixVersion = " + this.scholixVersion);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = DNGFRowKeyDecoder.decode((byte[])key.copyBytes()).getType();
        DNGFProtos.DNGF entity = HBaseTableDAO.getMetadata(value, type);
        if (this.isValid(entity)) {
            if (!this.deletedByInference(entity)) {
                byte[] source = ScholixConverter.withSource((DNGFProtos.DNGFEntity)entity.getEntity(), (ScholixVersion)ScholixVersion.valueOf((String)this.scholixVersion));
                this.emit(0, entity.getEntity().getId(), context, source);
                context.getCounter(SCHOLIX, "Source: " + entity.getEntity().getType().name()).increment(1L);
                HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(r -> {
                    if (!this.deletedByInference((DNGFProtos.DNGF)r)) {
                        byte[] target = ScholixConverter.withTarget((DNGFProtos.DNGFEntity)entity.getEntity(), (DNGFProtos.DNGFRel)r.getRel(), (Ontologies)this.ontologies, (ScholixVersion)ScholixVersion.valueOf((String)this.scholixVersion));
                        this.emit(1, r.getRel().getTarget(), context, target);
                        context.getCounter(SCHOLIX, "Rel type: " + r.getRel().getTargetType().name()).increment(1L);
                    } else {
                        context.getCounter(DNGF, "Rel deletedbyinference: " + type.name()).increment(1L);
                    }
                });
            } else {
                context.getCounter(DNGF, "Deletedbyinference: " + type.name()).increment(1L);
            }
        } else {
            context.getCounter(DNGF, "Invalid: " + type.name()).increment(1L);
        }
    }

    private boolean isValid(DNGFProtos.DNGF entity) {
        return entity != null && entity.isInitialized();
    }

    private boolean deletedByInference(DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private void emit(int keyType, String id, Mapper.Context context, byte[] data) {
        try {
            context.getCounter(SCHOLIX, keyType == 0 ? "ENTITY" : "REL").increment(1L);
            context.write((Object)DliKey.create(keyType, id), (Object)new ImmutableBytesWritable(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

