/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.oai.utils;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.SetCollection;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.SetInfo;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class MongoSetCollection
implements SetCollection {
    public static String DEFAULT_SET = "OTHER";
    private DB publisherDB;
    private String setCollection = "sets";
    private String setCountCollection = "setsCount";

    public MongoSetCollection(DB mongoDB) {
        this.publisherDB = mongoDB;
    }

    public void ensureIndexes() {
        this.ensureIndexesOnSets();
        this.ensureIndexesOnCount();
    }

    @Override
    public List<SetInfo> getAllSets() {
        DBCursor cursor = this.getSetsCollection().find();
        ArrayList res = Lists.newArrayList();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            res.add(this.getSetFromDBObject(obj));
        }
        return res;
    }

    @Override
    public boolean containSet(String set) {
        BasicDBObject query = new BasicDBObject("spec", (Object)set);
        return this.getSetsCollection().find((DBObject)query).limit(1).size() != 0;
    }

    @Override
    public String getSetQuery(String set) {
        BasicDBObject query = new BasicDBObject("spec", (Object)set);
        BasicDBObject returnField = new BasicDBObject("query", (Object)1);
        DBObject obj = this.getSetsCollection().findOne((DBObject)query, (DBObject)returnField);
        return (String)obj.get("query");
    }

    @Override
    public int count(String setSpec, String mdPrefix) {
        DBObject query = BasicDBObjectBuilder.start((String)"spec", (Object)setSpec).add("mdPrefix", (Object)mdPrefix).get();
        BasicDBObject returnField = new BasicDBObject("count", (Object)1);
        DBObject obj = this.getSetsCountCollection().findOne(query, (DBObject)returnField);
        return (Integer)obj.get("count");
    }

    public void updateCounts(String setSpec, String mdPrefix, int count) {
        DBObject setCount = BasicDBObjectBuilder.start((String)"spec", (Object)setSpec).add("mdPrefix", (Object)mdPrefix).get();
        this.getSetsCountCollection().update(setCount, (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("count", (Object)count)), true, false);
    }

    public void upsertSet(SetInfo setInfo, boolean fromConfiguration) {
        DBObject obj = this.getObjectFromSet(setInfo);
        obj.put("fromConfiguration", (Object)fromConfiguration);
        this.getSetsCollection().update((DBObject)new BasicDBObject("spec", (Object)setInfo.getSetSpec()), obj, true, false);
    }

    public String normalizeSetSpec(String setName) {
        String s = StringEscapeUtils.unescapeXml((String)setName);
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll(" ", "_");
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^-_]]", "");
        s = s.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        String stripped = StringUtils.strip((String)(s = s.replaceAll("[\\W&&[^-_]]", "")), (String)"_ ");
        if (StringUtils.isBlank((CharSequence)stripped)) {
            stripped = DEFAULT_SET;
        }
        return stripped;
    }

    public List<SetInfo> getConfiguredSets() {
        BasicDBObject query = new BasicDBObject("fromConfiguration", (Object)true);
        return this.findSets((DBObject)query);
    }

    public List<SetInfo> getSetsFromData() {
        BasicDBObject query = new BasicDBObject("fromConfiguration", (Object)false);
        return this.findSets((DBObject)query);
    }

    public void dropOAISets() {
        this.getSetsCountCollection().drop();
        this.getSetsCollection().drop();
    }

    public void dropConfigurationSets() {
        this.getSetsCollection().remove((DBObject)new BasicDBObject("fromConfiguration", (Object)true));
    }

    protected List<SetInfo> findSets(DBObject query) {
        DBCursor cursor = this.getSetsCollection().find(query);
        ArrayList res = Lists.newArrayList();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            res.add(this.getSetFromDBObject(obj));
        }
        return res;
    }

    private SetInfo getSetFromDBObject(DBObject obj) {
        SetInfo setInfo = new SetInfo();
        setInfo.setEnabled((Boolean)obj.get("enabled"));
        setInfo.setQuery((String)obj.get("query"));
        setInfo.setSetDescription((String)obj.get("description"));
        setInfo.setSetName((String)obj.get("name"));
        setInfo.setSetSpec((String)obj.get("spec"));
        return setInfo;
    }

    private DBObject getObjectFromSet(SetInfo s) {
        DBObject obj = BasicDBObjectBuilder.start((String)"spec", (Object)s.getSetSpec()).add("name", (Object)s.getSetName()).add("description", (Object)s.getSetDescription()).add("query", (Object)s.getQuery()).add("enabled", (Object)s.isEnabled()).get();
        return obj;
    }

    private void ensureIndexesOnSets() {
        this.getSetsCollection().createIndex((DBObject)new BasicDBObject("spec", (Object)1));
        this.getSetsCollection().createIndex((DBObject)new BasicDBObject("fromConfiguration", (Object)1));
    }

    private void ensureIndexesOnCount() {
        DBObject index = BasicDBObjectBuilder.start((String)"spec", (Object)1).add("mdPrefix", (Object)1).get();
        this.getSetsCountCollection().createIndex(index);
    }

    public DBCollection getSetsCollection() {
        return this.getCollection(this.setCollection);
    }

    public DBCollection getSetsCountCollection() {
        return this.getCollection(this.setCountCollection);
    }

    private DBCollection getCollection(String collectionName) {
        return this.publisherDB.getCollection(collectionName);
    }

    public DB getPublisherDB() {
        return this.publisherDB;
    }

    public void setPublisherDB(DB publisherDB) {
        this.publisherDB = publisherDB;
    }

    public String getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(String setCollection) {
        this.setCollection = setCollection;
    }

    public String getSetCountCollection() {
        return this.setCountCollection;
    }

    public void setSetCountCollection(String setCountCollection) {
        this.setCountCollection = setCountCollection;
    }
}

