package eu.dnetlib.data.mapreduce;

import java.util.List;

public class OptionalConfig {

	private com.typesafe.config.Config config;

	public OptionalConfig(com.typesafe.config.Config config) {
		this.config = config;
	}

	protected Object safe(String path) {
		return config.hasPath(path) ? config.getAnyRef(path) : null;
	}

	public Integer getInt(String path) {
		return (Integer) safe(path);
	}

	public String getString(String path) {
		return (String) safe(path);
	}
	
	@SuppressWarnings("unchecked")
	public <T> List<T> getList(String path) {
		return (List<T>) safe(path);
	}	

	public Double getDouble(String path) {
		Object safe = safe(path);
		if (safe instanceof Integer) {
			return Double.parseDouble(safe.toString());
		}
		return (Double) safe;
	}

	public Object getObject(String path) {
		return safe(path);
	}

	public Boolean getBoolean(String path) {
		return (Boolean) safe(path);
	}
	
	public Boolean hasPath(String path) {
		return getConfig().hasPath(path);
	}

	public com.typesafe.config.Config getConfig() {
		return config;
	}

}
