/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.OptionalConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IndexConfig
extends OptionalConfig {
    public IndexConfig(Config config) {
        super(config);
    }

    public static IndexConfig load(String s) {
        return new IndexConfig(ConfigFactory.parseReader((Reader)new StringReader(s)));
    }

    public EntityConfigTable getConfigMap() {
        ConfigObject modelMap = this.getConfig().getObject("index.conf");
        Map map = Maps.transformValues((Map)modelMap, value -> {
            HashMap links = Maps.newHashMap();
            for (Object o : (List)((Map)value.unwrapped()).get("links")) {
                Map map1 = (Map)o;
                RelDescriptor relDescriptor = new RelDescriptor((String)map1.get("relType"));
                HashSet fields = Sets.newHashSet((Iterable)((List)map1.get("fields")));
                TypeProtos.Type target = TypeProtos.Type.valueOf((String)((String)map1.get("targetEntity")));
                Boolean isChild = map1.get("expandAs").equals("child");
                Boolean symmetric = (Boolean)map1.get("symmetric");
                LinkDescriptor ld = new LinkDescriptor(relDescriptor, target, isChild, symmetric, fields);
                if (map1.containsKey("max")) {
                    ld.setMax((Integer)map1.get("max"));
                }
                links.put(relDescriptor, ld);
            }
            return new EntityConfig((Boolean)((Map)value.unwrapped()).get("dups"), links);
        });
        EntityConfigTable res = new EntityConfigTable();
        for (String key : map.keySet()) {
            res.put(TypeProtos.Type.valueOf((String)key), map.get(key));
        }
        return res;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

