/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFEntityDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextDef;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.AbstractRecordFactory;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JSONRecordFactory
extends AbstractRecordFactory {
    public JSONRecordFactory(EntityConfigTable entityConfigTable, ContextMapper contextMapper, Ontologies ontologies, boolean entityDefaults, boolean relDefaults, boolean childDefaults) {
        super(entityConfigTable, contextMapper, ontologies, entityDefaults, relDefaults, childDefaults);
    }

    @Override
    public String build() {
        try {
            DNGFEntityDecoder entity = this.mainEntity.decodeEntity();
            JsonObject result = new JsonObject();
            TypeProtos.Type type = entity.getType();
            JsonArray rels = this.listRelations();
            result.add("rels", (JsonElement)rels);
            this.buildContexts(type, result);
            result.add("metadata", (JsonElement)this.decodeType(entity, null, this.entityDefaults, false));
            return result.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("error building record '%s'", this.key), e);
        }
    }

    private JsonObject decodeType(DNGFEntityDecoder decoder, Set<String> filter, boolean defaults, boolean expandingRel) {
        JsonObject root = new JsonObject();
        this.addFields(root, decoder.getMetadata(), filter, defaults, expandingRel);
        if (decoder.getEntity() instanceof PublicationProtos.Publication && !expandingRel) {
            this.asJsonElement("bestlicense", "", this.getBestLicense(), null, root);
            this.addFields(root, decoder.getEntity(), filter, defaults, expandingRel);
        }
        if (decoder.getEntity() instanceof PersonProtos.Person && !expandingRel) {
            this.addFields(root, decoder.getEntity(), filter, defaults, expandingRel);
        }
        if (decoder.getEntity() instanceof ProjectProtos.Project && !expandingRel) {
            this.addFields(root, decoder.getEntity(), filter, defaults, expandingRel);
        }
        return root;
    }

    private void addFields(JsonObject metadata, GeneratedMessage fields, Set<String> filter, boolean defaults, boolean expandingRel) {
        if (fields != null) {
            HashSet seen = Sets.newHashSet();
            for (Map.Entry<Descriptors.FieldDescriptor, Object> e : this.filterFields(fields, filter)) {
                String name = e.getKey().getName();
                seen.add(name);
                this.addFieldValue(metadata, e.getKey(), e.getValue(), expandingRel);
            }
            if (defaults) {
                for (Descriptors.FieldDescriptor fd : fields.getDescriptorForType().getFields()) {
                    if (seen.contains(fd.getName())) continue;
                    this.addFieldValue(metadata, fd, this.getDefault(fd), expandingRel);
                }
            }
        }
    }

    private void addFieldValue(JsonObject metadata, Descriptors.FieldDescriptor fd, Object value, boolean expandingRel) {
        if ("dateofcollection".equals(fd.getName()) || "dateoftransformation".equals(fd.getName()) || "id".equals(fd.getName()) || value == null) {
            return;
        }
        if (fd.getName().equals("datasourcetype")) {
            String classid = ((FieldTypeProtos.Qualifier)value).getClassid();
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)((FieldTypeProtos.Qualifier)value));
            if (this.specialDatasourceTypes.contains(classid)) {
                q.setClassid("other").setClassname("other");
            }
            this.asJsonElement("datasourcetypeui", "", q.build(), null, metadata);
        }
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.guessType(metadata, fd, o, expandingRel);
            }
        } else {
            this.guessType(metadata, fd, value, expandingRel);
        }
    }

    private void guessType(JsonObject metadata, Descriptors.FieldDescriptor fd, Object object, boolean expandingRel) {
        if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.Qualifier qualifier = (FieldTypeProtos.Qualifier)object;
                this.asJsonElement(fd.getName(), "", qualifier, null, metadata);
            } else if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.StructuredProperty sp = (FieldTypeProtos.StructuredProperty)object;
                this.asJsonElement(fd.getName(), sp.getValue(), sp.getQualifier(), sp.hasDataInfo() ? sp.getDataInfo() : null, metadata);
                if (!expandingRel && fd.getName().equals("pid") && sp.getQualifier().getClassid().equalsIgnoreCase("doi")) {
                    this.incrementCounter("doi");
                }
            } else if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.KeyValue kv = (FieldTypeProtos.KeyValue)object;
                JsonObject tmp = new JsonObject();
                tmp.addProperty("name", kv.getValue());
                tmp.addProperty("id", JSONRecordFactory.removePrefix(kv.getValue()));
                metadata.add(fd.getName(), (JsonElement)tmp);
            } else if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                String fieldName = fd.getName();
                FieldTypeProtos.StringField sf = (FieldTypeProtos.StringField)object;
                JsonObject sb = new JsonObject();
                if (sf.hasDataInfo()) {
                    FieldTypeProtos.DataInfo dataInfo = sf.getDataInfo();
                    this.dataInfoAsAttributes(sb, dataInfo);
                    if (!StringUtils.isEmpty((CharSequence)sf.getValue())) {
                        sb.addProperty("value", sf.getValue());
                    }
                    if (sb.entrySet().size() > 0) {
                        metadata.add(fieldName, (JsonElement)sb);
                    }
                } else if (!StringUtils.isEmpty((CharSequence)sf.getValue())) {
                    metadata.addProperty(fd.getName(), sf.getValue());
                }
            } else if (FieldTypeProtos.BoolField.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.BoolField bf = (FieldTypeProtos.BoolField)object;
                if (bf.hasDataInfo()) {
                    JsonObject sb = new JsonObject();
                    FieldTypeProtos.DataInfo dataInfo = bf.getDataInfo();
                    this.dataInfoAsAttributes(sb, dataInfo);
                    sb.addProperty("value", Boolean.valueOf(bf.getValue()));
                    metadata.add(fd.getName(), (JsonElement)sb);
                } else {
                    metadata.addProperty(fd.getName(), Boolean.valueOf(bf.getValue()));
                }
            } else if (FieldTypeProtos.Journal.getDescriptor().equals(fd.getMessageType()) && object != null) {
                FieldTypeProtos.Journal j = (FieldTypeProtos.Journal)object;
                JsonObject journal = new JsonObject();
                journal.addProperty("issn", j.getIssnPrinted());
                journal.addProperty("eissn", j.getIssnOnline());
                journal.addProperty("lissn", j.getIssnLinking());
                journal.addProperty("value", j.getName());
                metadata.add("journal", (JsonElement)journal);
            } else if (FieldTypeProtos.Context.getDescriptor().equals(fd.getMessageType()) && object != null) {
                this.contextes.add(((FieldTypeProtos.Context)object).getId());
            } else if (FieldTypeProtos.ExtraInfo.getDescriptor().equals(fd.getMessageType()) && object != null) {
                FieldTypeProtos.ExtraInfo e = (FieldTypeProtos.ExtraInfo)object;
                JsonObject sb = new JsonObject();
                sb.addProperty("name", e.getName());
                sb.addProperty("typology", e.getTypology());
                sb.addProperty("provenance", e.getProvenance());
                sb.addProperty("trust", e.getTrust());
                sb.addProperty("value", e.getValue());
                metadata.add(fd.getName(), (JsonElement)sb);
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            if (fd.getFullName().equals("eu.dnetlib.data.proto.DNGFEntity.type")) {
                return;
            }
            this.asJsonElement(fd.getName(), ((Descriptors.EnumValueDescriptor)object).getName(), null, null, metadata);
        } else {
            this.asJsonElement(fd.getName(), object.toString(), null, null, metadata);
        }
    }

    private JsonArray listRelations() {
        JsonArray relations = new JsonArray();
        for (DNGFDecoder decoder : this.relations) {
            JsonObject root = new JsonObject();
            DNGFProtos.DNGFRel rel = decoder.getDNGFRel();
            DNGFProtos.DNGFEntity cachedTarget = rel.getCachedTarget();
            DNGFRelDecoder relDecoder = DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel);
            if (!relDecoder.getRelSourceId().equals(this.key) && !relDecoder.getRelTargetId().equals(this.key)) continue;
            TypeProtos.Type targetType = relDecoder.getTargetType();
            Set<String> relFilter = this.entityConfigTable.getFilter(targetType, relDecoder.getRelDescriptor());
            this.addFields(root, (GeneratedMessage)relDecoder.getDngfRel(), relFilter, false, true);
            RelDescriptor relDescriptor = relDecoder.getRelDescriptor();
            if (cachedTarget != null && cachedTarget.isInitialized()) {
                Set<String> filter = this.entityConfigTable.getFilter(targetType, relDescriptor);
                root.add("cachedTarget", (JsonElement)this.decodeType(DNGFEntityDecoder.decode((DNGFProtos.DNGFEntity)cachedTarget), filter, this.relDefaults, true));
            }
            String semanticclass = this.ontologies.inverseOf(relDescriptor);
            String semanticscheme = relDescriptor.getOntologyCode();
            String rd = semanticscheme + "_" + semanticclass;
            this.incrementCounter(rd);
            FieldTypeProtos.DataInfo info = decoder.getDNGF().getDataInfo();
            this.manageInferred(rd, info);
            LinkDescriptor ld = this.entityConfigTable.getDescriptor(relDecoder.getTargetType(), relDescriptor);
            String relId = ld != null && !ld.isSymmetric() ? relDecoder.getRelTargetId() : relDecoder.getRelSourceId();
            relations.add((JsonElement)root);
        }
        return relations;
    }

    private void buildContexts(TypeProtos.Type type, JsonObject metadata) {
        if (this.contextMapper != null && !this.contextMapper.isEmpty() && type.equals((Object)TypeProtos.Type.publication)) {
            JsonObject contextRoot = new JsonObject();
            JsonArray contexts = new JsonArray();
            contextRoot.add("contextRoot", (JsonElement)contexts);
            for (String context : this.contextes) {
                String id = "";
                for (String token : Splitter.on((String)"::").split((CharSequence)context)) {
                    ContextDef def = (ContextDef)this.contextMapper.get(id = id + token);
                    if (def == null) {
                        throw new IllegalStateException(String.format("cannot find context for id '%s'", id));
                    }
                    if (def.getName().equals("context") && !this.findExistingContext(contexts, def.getId())) {
                        this.addContextDef(contexts, def);
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        this.addContextDef(contexts, def);
                    }
                    if (def.getName().equals("concept")) {
                        this.addContextDef(contexts, def);
                    }
                    id = id + "::";
                }
            }
        }
    }

    private boolean findExistingContext(JsonArray contexes, String id) {
        for (JsonElement item : contexes) {
            if (!item.getAsJsonObject().has("context") || !item.getAsJsonObject().get("context").getAsJsonObject().get("id").getAsString().equals(id)) continue;
            return true;
        }
        return false;
    }

    private void addContextDef(JsonArray tags, ContextDef def) {
        JsonObject defContext = new JsonObject();
        defContext.addProperty("id", def.getId());
        defContext.addProperty("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            defContext.addProperty("type", def.getType());
        }
        JsonObject result = new JsonObject();
        result.add(def.getName(), (JsonElement)defContext);
        tags.add((JsonElement)result);
    }

    private void asJsonElement(String name, String value, FieldTypeProtos.Qualifier q, FieldTypeProtos.DataInfo dataInfo, JsonObject metadata) {
        JsonObject root = new JsonObject();
        this.getAttributes(q, root);
        if (dataInfo != null) {
            this.dataInfoAsAttributes(root, dataInfo);
        }
        if (value != null && !StringUtils.isEmpty((CharSequence)value)) {
            root.addProperty("value", value);
        }
        if (root.entrySet().size() > 0) {
            metadata.add(name, (JsonElement)root);
        }
    }

    private void getAttributes(FieldTypeProtos.Qualifier q, JsonObject root) {
        if (q == null) {
            return;
        }
        q.getAllFields().entrySet().forEach(e -> root.addProperty(((Descriptors.FieldDescriptor)e.getKey()).getName(), e.getValue().toString()));
    }

    private void dataInfoAsAttributes(JsonObject root, FieldTypeProtos.DataInfo dataInfo) {
        root.addProperty("inferred", Boolean.valueOf(dataInfo.getInferred()));
        root.addProperty("inferenceprovenance", dataInfo.getInferenceprovenance());
        root.addProperty("provenanceaction", dataInfo.getProvenanceaction().getClassid());
        root.addProperty("trust", dataInfo.getTrust());
    }
}

