package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.util.List;

import com.google.gson.Gson;

public class RootEntity {

	private String joaf;
	private List<String> mergedIds;

	public RootEntity() {}

	public RootEntity(final String joaf, final List<String> mergedIds) {
		super();
		this.setJoaf(joaf);
		this.setMergedIds(mergedIds);
	}

	public static RootEntity decode(final String s) {
		return new Gson().fromJson(s, RootEntity.class);
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	public String getJoaf() {
		return joaf;
	}

	public void setJoaf(final String joaf) {
		this.joaf = joaf;
	}

	public List<String> getMergedIds() {
		return mergedIds;
	}

	public void setMergedIds(final List<String> mergedIds) {
		this.mergedIds = mergedIds;
	}
}
